/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.traversal;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.serialization.context.JsonLdContext;
import cz.cvut.kbss.jsonld.serialization.traversal.ObjectGraphTraverser;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

class PropertiesTraverser {
    private final ObjectGraphTraverser parent;

    PropertiesTraverser(ObjectGraphTraverser parent) {
        this.parent = parent;
    }

    public void traverseProperties(SerializationContext<Map<?, ?>> ctx) {
        for (Map.Entry<?, ?> e : ctx.getValue().entrySet()) {
            String property = e.getKey().toString();
            if (e.getValue() == null) continue;
            if (e.getValue() instanceof Collection) {
                Collection propertyValues = (Collection)e.getValue();
                this.serializePropertyValues(property, propertyValues, ctx.getJsonLdContext());
                continue;
            }
            this.visitSingleValue(property, e.getValue(), ctx.getJsonLdContext());
        }
    }

    private void visitSingleValue(String property, Object value, JsonLdContext jsonLdContext) {
        assert (value != null);
        if (PropertiesTraverser.isTraversable(value)) {
            this.parent.traverseSingular(new SerializationContext<Object>(property, value, jsonLdContext));
        } else {
            this.parent.visitAttribute(new SerializationContext<Object>(property, value, jsonLdContext));
        }
    }

    private static boolean isTraversable(Object value) {
        Class<?> cls = value.getClass();
        return BeanClassProcessor.isIdentifierType(value.getClass()) && !String.class.equals(cls) || BeanAnnotationProcessor.isOwlClassEntity(value.getClass()) || BeanAnnotationProcessor.hasTypesField(cls);
    }

    private void serializePropertyValues(String property, Collection<?> values, JsonLdContext jsonLdContext) {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() == 1) {
            Object val = values.iterator().next();
            if (val != null) {
                this.visitSingleValue(property, val, jsonLdContext);
            }
        } else {
            SerializationContext colContext = new SerializationContext(property, values, jsonLdContext);
            this.parent.openCollection(colContext);
            values.stream().filter(Objects::nonNull).forEach(v -> this.visitSingleValue(null, v, jsonLdContext));
            this.parent.closeCollection(colContext);
        }
    }
}

