/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.traversal;

import cz.cvut.kbss.jsonld.serialization.context.JsonLdContext;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;

public class SerializationContext<T>
implements JsonLdContext {
    private String term;
    private final Field field;
    private final T value;
    private JsonLdContext jsonLdContext;

    public SerializationContext(String term, T value, JsonLdContext jsonLdContext) {
        this(term, null, value, jsonLdContext);
    }

    public SerializationContext(Field field, T value, JsonLdContext jsonLdContext) {
        this(null, field, value, jsonLdContext);
    }

    public SerializationContext(T value, JsonLdContext jsonLdContext) {
        this(null, null, value, jsonLdContext);
    }

    public SerializationContext(String term, Field field, T value, JsonLdContext jsonLdContext) {
        this.term = term;
        this.field = field;
        this.value = value;
        this.jsonLdContext = jsonLdContext;
    }

    public String getTerm() {
        return this.term;
    }

    public Field getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.field != null ? this.field.getName() : null;
    }

    public T getValue() {
        return this.value;
    }

    public JsonLdContext getJsonLdContext() {
        return this.jsonLdContext;
    }

    public void setJsonLdContext(JsonLdContext jsonLdContext) {
        this.jsonLdContext = jsonLdContext;
    }

    @Override
    public void registerTermMapping(String term, String iri) {
        this.jsonLdContext.registerTermMapping(term, iri);
        this.term = term;
    }

    @Override
    public void registerTermMapping(String term, ObjectNode mappedNode) {
        this.jsonLdContext.registerTermMapping(term, mappedNode);
        this.term = term;
    }

    @Override
    public Optional<JsonNode> getTermMapping(String term) {
        return this.jsonLdContext.getTermMapping(term);
    }

    @Override
    public boolean hasTermMapping(String term) {
        return this.jsonLdContext.hasTermMapping(term);
    }

    @Override
    public Optional<String> getMappedTerm(String iri) {
        return this.jsonLdContext.getMappedTerm(iri);
    }

    @Override
    public boolean isCurrentEmpty() {
        return this.jsonLdContext.isCurrentEmpty();
    }

    @Override
    public ObjectNode getContextNode() {
        return this.jsonLdContext.getContextNode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationContext that = (SerializationContext)o;
        return Objects.equals(this.getTerm(), that.getTerm()) && Objects.equals(this.getField(), that.getField()) && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getTerm(), this.getField(), this.getValue());
    }
}

