/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.traversal;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.serialization.context.JsonLdContext;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.lang.reflect.Field;
import java.util.Set;

public class SerializationContextFactory {
    private final JsonLdContext rootContext;

    public SerializationContextFactory(JsonLdContext rootContext) {
        this.rootContext = rootContext;
    }

    public <T> SerializationContext<T> create(T value) {
        return new SerializationContext<T>(value, this.rootContext);
    }

    public <T> SerializationContext<T> create(T value, SerializationContext<?> current) {
        return new SerializationContext<T>(value, current.getJsonLdContext());
    }

    public <T> SerializationContext<T> createForProperties(Field field, T value, SerializationContext<?> current) {
        assert (BeanAnnotationProcessor.isPropertiesField(field));
        return new SerializationContext<T>(field, value, current.getJsonLdContext());
    }

    public <T> SerializationContext<T> createForAttribute(Field field, T value, SerializationContext<?> current) {
        return new SerializationContext<T>(BeanAnnotationProcessor.getAttributeIdentifier(field), field, value, current.getJsonLdContext());
    }

    public SerializationContext<String> createForIdentifier(Field field, String value, SerializationContext<?> current) {
        return new SerializationContext<String>("@id", field, value, current.getJsonLdContext());
    }

    public SerializationContext<Set<String>> createForTypes(Field field, Set<String> value, SerializationContext<?> current) {
        return new SerializationContext<Set<String>>("@type", field, value, current.getJsonLdContext());
    }
}

