/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.ByteArray;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.AsymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.EncryptionFactories;
import cz.d1x.dxcrypto.encryption.RSAAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.SymmetricAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.crypto.CryptoFactories;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;

public class EncryptionAlgorithms {
    private static EncryptionFactories defaultFactories = new CryptoFactories();

    public static void defaultFactories(EncryptionFactories factories) {
        if (factories == null) {
            throw new IllegalArgumentException("You must provide non-null engine factories!");
        }
        defaultFactories = factories;
    }

    public static SymmetricAlgorithmBuilder aes(byte[] keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        SymmetricEncryptionEngineFactory<ByteArray> engineFactory = defaultFactories.aes();
        SymmetricAlgorithmBuilder builder = new SymmetricAlgorithmBuilder(defaultFactories, engineFactory, 128, 128);
        return builder.keyPassword(keyPassword);
    }

    public static SymmetricAlgorithmBuilder aes(String keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        return EncryptionAlgorithms.aes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricAlgorithmBuilder aes() {
        return EncryptionAlgorithms.aes(new byte[0]);
    }

    public static SymmetricAlgorithmBuilder aes256(byte[] keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        SymmetricEncryptionEngineFactory<ByteArray> engineFactory = defaultFactories.aes256();
        SymmetricAlgorithmBuilder builder = new SymmetricAlgorithmBuilder(defaultFactories, engineFactory, 256, 128);
        return builder.keyPassword(keyPassword);
    }

    public static SymmetricAlgorithmBuilder aes256(String keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        return EncryptionAlgorithms.aes256(Encoding.getBytes(keyPassword));
    }

    public static SymmetricAlgorithmBuilder aes256() {
        return EncryptionAlgorithms.aes256(new byte[0]);
    }

    public static SymmetricAlgorithmBuilder tripleDes(byte[] keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        int keySize = 192;
        SymmetricEncryptionEngineFactory<ByteArray> engineFactory = defaultFactories.tripleDes();
        SymmetricAlgorithmBuilder builder = new SymmetricAlgorithmBuilder(defaultFactories, engineFactory, keySize, 64);
        return builder.keyPassword(keyPassword);
    }

    public static SymmetricAlgorithmBuilder tripleDes(String keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        return EncryptionAlgorithms.tripleDes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricAlgorithmBuilder tripleDes() {
        return EncryptionAlgorithms.tripleDes(new byte[0]);
    }

    public static RSAAlgorithmBuilder rsa() {
        AsymmetricEncryptionEngineFactory<RSAKeyParams, RSAKeyParams> factory = defaultFactories.rsa();
        return new RSAAlgorithmBuilder(factory);
    }
}

