/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.StreamingEncryptionEngine;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoSymmetricEngine
implements StreamingEncryptionEngine {
    private final String cipherName;
    private final Key key;

    public CryptoSymmetricEngine(String cipherName, byte[] key) throws EncryptionException {
        this.cipherName = cipherName;
        String shortCipherName = cipherName.contains("/") ? cipherName.substring(0, cipherName.indexOf("/")) : cipherName;
        this.checkJCE(shortCipherName, key.length);
        this.key = new SecretKeySpec(key, shortCipherName);
        try {
            Cipher.getInstance(cipherName);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Invalid encryption algorithm", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input, byte[] initVector) throws EncryptionException {
        return this.doOperation(input, initVector, true);
    }

    @Override
    public OutputStream encrypt(OutputStream output, byte[] initVector) {
        Cipher cipher = this.createCipher(initVector, true);
        return new CipherOutputStream(output, cipher);
    }

    @Override
    public OutputStream decrypt(OutputStream output, byte[] initVector) throws EncryptionException {
        Cipher cipher = this.createCipher(initVector, false);
        return new CipherOutputStream(output, cipher);
    }

    @Override
    public byte[] decrypt(byte[] input, byte[] initVector) {
        return this.doOperation(input, initVector, false);
    }

    @Override
    public InputStream encrypt(InputStream input, byte[] initVector) throws EncryptionException {
        Cipher cipher = this.createCipher(initVector, true);
        return new CipherInputStream(input, cipher);
    }

    @Override
    public InputStream decrypt(InputStream input, byte[] initVector) {
        Cipher cipher = this.createCipher(initVector, false);
        return new CipherInputStream(input, cipher);
    }

    private Cipher createCipher(byte[] initVector, boolean isEncrypt) {
        try {
            IvParameterSpec iv = new IvParameterSpec(initVector);
            Cipher cipher = Cipher.getInstance(this.cipherName);
            cipher.init(isEncrypt ? 1 : 2, this.key, iv);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to create cipher", e);
        }
    }

    private byte[] doOperation(byte[] input, byte[] initVector, boolean isEncrypt) {
        try {
            Cipher cipher = this.createCipher(initVector, isEncrypt);
            return cipher.doFinal(input);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to encrypt input", e);
        }
    }

    private void checkJCE(String name, int keySize) {
        IllegalArgumentException exc = new IllegalArgumentException("Cipher " + name + " is not supported with key size of " + keySize + "b,  probably Java Cryptography Extension (JCE) is not installed in your Java.");
        try {
            if (Cipher.getMaxAllowedKeyLength(name) < keySize) {
                throw exc;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw exc;
        }
    }
}

