/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.io;

import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IvStreamHelper {
    private final int _blockSize;

    public IvStreamHelper(int blockSize) {
        this._blockSize = blockSize;
    }

    public byte[] extractIv(InputStream input) throws EncryptionException {
        try {
            byte[] iv = new byte[this._blockSize];
            int bytesRead = IOUtils.read(input, iv);
            if (bytesRead < this._blockSize) {
                throw new EncryptionException("Wrong data in input stream");
            }
            return iv;
        }
        catch (IOException e) {
            throw new EncryptionException("Error occurred during iv extraction.", e);
        }
    }

    public void writeIv(OutputStream output, byte[] iv) {
        try {
            output.write(iv);
        }
        catch (IOException e) {
            throw new EncryptionException("Error occurred during iv write.", e);
        }
    }
}

