/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingException;

public final class RepeatingDecorator
implements HashingAlgorithm {
    private final HashingAlgorithm hashingAlgorithm;
    private final int repeatsCount;

    protected RepeatingDecorator(HashingAlgorithm hashingAlgorithm, int repeatsCount) {
        this.hashingAlgorithm = hashingAlgorithm;
        this.repeatsCount = repeatsCount;
    }

    @Override
    public String hash(String input) throws HashingException {
        return this.repeat(input);
    }

    @Override
    public byte[] hash(byte[] input) throws HashingException {
        return this.repeat(input);
    }

    private String repeat(String text) {
        for (int i = 0; i < this.repeatsCount; ++i) {
            text = this.hashingAlgorithm.hash(text);
        }
        return text;
    }

    private byte[] repeat(byte[] input) {
        for (int i = 0; i < this.repeatsCount; ++i) {
            input = this.hashingAlgorithm.hash(input);
        }
        return input;
    }
}

