/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Combining;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingException;
import cz.d1x.dxcrypto.hash.SaltedHashingAlgorithm;

public final class SaltingAdapter
implements SaltedHashingAlgorithm {
    private final HashingAlgorithm hashingAlgorithm;
    private final Combining inputSaltCombining;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    protected SaltingAdapter(HashingAlgorithm hashingAlgorithm, BytesRepresentation bytesRepresentation, Combining inputSaltCombining, String encoding) {
        if (hashingAlgorithm == null) {
            throw new IllegalArgumentException("Expecting non-null adapted algorithm");
        }
        this.hashingAlgorithm = hashingAlgorithm;
        if (inputSaltCombining == null) {
            throw new IllegalArgumentException("Expecting non-null combine strategy");
        }
        this.inputSaltCombining = inputSaltCombining;
        this.bytesRepresentation = bytesRepresentation;
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
    }

    @Override
    public String hash(String input, String salt) throws HashingException {
        byte[] inputBytes = Encoding.getBytes(input, this.encoding);
        byte[] saltBytes = Encoding.getBytes(salt, this.encoding);
        byte[] hashed = this.hash(inputBytes, saltBytes);
        return this.bytesRepresentation.toString(hashed);
    }

    @Override
    public byte[] hash(byte[] input, byte[] salt) throws HashingException {
        byte[] toHash = this.inputSaltCombining.combine(input, salt);
        return this.hashingAlgorithm.hash(toHash);
    }
}

