/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Combining;
import cz.d1x.dxcrypto.common.ConcatAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.SaltedHashingAlgorithm;
import cz.d1x.dxcrypto.hash.SaltingAdapter;

public final class SaltingAdapterBuilder {
    private final HashingAlgorithm hashingAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;
    private Combining inputSaltCombining = new ConcatAlgorithm();

    public SaltingAdapterBuilder(HashingAlgorithm hashingAlgorithm, BytesRepresentation bytesRepresentation, String encoding) {
        this.hashingAlgorithm = hashingAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
    }

    public SaltingAdapterBuilder inputAndSaltCombining(Combining combining) {
        if (combining == null) {
            throw new IllegalArgumentException("You must provide non-null Combining!");
        }
        this.inputSaltCombining = combining;
        return this;
    }

    public SaltedHashingAlgorithm build() {
        return new SaltingAdapter(this.hashingAlgorithm, this.bytesRepresentation, this.inputSaltCombining, this.encoding);
    }
}

