/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.props;

import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import java.util.Properties;

public class SecureProperties
extends Properties {
    private static final String DEFAULT_ENCRYPTED_SUFFIX = "xa3s";
    private final EncryptionAlgorithm encryptionAlgorithm;
    private final String encryptedPropertySuffix;

    public SecureProperties(EncryptionAlgorithm encryptionAlgorithm) {
        this(encryptionAlgorithm, DEFAULT_ENCRYPTED_SUFFIX);
    }

    public SecureProperties(Properties defaults, EncryptionAlgorithm encryptionAlgorithm) {
        this(defaults, encryptionAlgorithm, DEFAULT_ENCRYPTED_SUFFIX);
    }

    public SecureProperties(EncryptionAlgorithm encryptionAlgorithm, String encryptedPropertySuffix) {
        this(null, encryptionAlgorithm, encryptedPropertySuffix);
    }

    public SecureProperties(Properties defaults, EncryptionAlgorithm encryptionAlgorithm, String encryptedPropertySuffix) {
        super(defaults);
        this.encryptionAlgorithm = encryptionAlgorithm;
        if (encryptedPropertySuffix == null || encryptedPropertySuffix.trim().isEmpty()) {
            throw new IllegalArgumentException("Encryption suffix must be non-null and must have at least one character after trimming");
        }
        this.encryptedPropertySuffix = encryptedPropertySuffix.trim();
    }

    public synchronized Object setEncryptedProperty(String key, String value) {
        if (value == null) {
            return super.setProperty(key, null);
        }
        String encryptedValue = this.encryptionAlgorithm.encrypt(value) + this.encryptedPropertySuffix;
        return super.setProperty(key, encryptedValue);
    }

    public String getOriginalProperty(String key) {
        return super.getProperty(key);
    }

    @Override
    public String getProperty(String key) {
        return this.getPlainOrEncrypted(key, super.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getPlainOrEncrypted(key, super.getProperty(key, defaultValue));
    }

    public boolean isEncrypted(String key) {
        String propertyValue = super.getProperty(key);
        return propertyValue != null && propertyValue.endsWith(this.encryptedPropertySuffix);
    }

    public boolean validateValue(String key, String expectedValue) {
        String propertyValue = this.getProperty(key);
        return propertyValue != null ? propertyValue.equals(expectedValue) : expectedValue == null;
    }

    private String getPlainOrEncrypted(String key, String value) {
        if (this.isEncrypted(key)) {
            String withoutSuffix = value.substring(0, value.length() - this.encryptedPropertySuffix.length());
            return this.encryptionAlgorithm.decrypt(withoutSuffix);
        }
        return value;
    }
}

