/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.cache.impl;

import cz.datalite.cache.CacheService;
import cz.datalite.cache.model.ServiceResult;
import cz.datalite.helpers.EqualsHelper;
import cz.datalite.stereotype.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;

@Service
public class CacheServiceImpl
implements CacheService {
    private ThreadLocal<Map<Class<?>, Map>> values = new ThreadLocal<Map<Class<?>, Map>>(){

        @Override
        protected Map<Class<?>, Map> initialValue() {
            return new LinkedHashMap();
        }
    };
    private ThreadLocal<Boolean> enabledForThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Override
    public boolean isEnabled() {
        return this.enabledForThread.get();
    }

    @Override
    public boolean setEnabled(boolean value) {
        boolean ret = this.isEnabled();
        this.enabledForThread.set(value);
        return ret;
    }

    @Override
    public <CacheType, XmlType, DatabaseType> void addToCache(Class<CacheType> cacheType, XmlType key, DatabaseType value) {
        if (!this.isEnabled()) {
            return;
        }
        Map<XmlType, DatabaseType> arrays = new LinkedHashMap();
        if (this.values.get().containsKey(cacheType)) {
            arrays = this.values.get().get(cacheType);
        } else {
            this.values.get().put(cacheType, arrays);
        }
        arrays.put(key, value);
    }

    @Override
    public <CacheType, XmlType, DatabaseType> DatabaseType removeFromCache(Class<CacheType> cacheType, XmlType key, DatabaseType value) {
        if (!this.isEnabled()) {
            return null;
        }
        Map arrays = new LinkedHashMap();
        if (this.values.get().containsKey(cacheType)) {
            arrays = this.values.get().get(cacheType);
        }
        DatabaseType ret = null;
        if (arrays.containsKey(key)) {
            if (arrays.get(key) instanceof Collection) {
                Collection collection = (Collection)arrays.get(key);
                for (Object obj : collection) {
                    if (!EqualsHelper.isEquals(obj, value)) continue;
                    ret = (DatabaseType)obj;
                    break;
                }
                if (ret != null) {
                    collection.remove(ret);
                }
                if (collection.isEmpty()) {
                    arrays.remove(key);
                }
            } else {
                ret = (DatabaseType)arrays.get(key);
                arrays.remove(key);
            }
        }
        return ret;
    }

    @Override
    public <CacheType, XmlType> boolean isExistsInCache(Class<CacheType> cacheType, XmlType key) {
        return this.isEnabled() && this.values.get().containsKey(cacheType) && this.values.get().get(cacheType).containsKey(key);
    }

    @Override
    public <CacheType, XmlType, DatabaseType> boolean isExistsInCache(Class<CacheType> cacheType, XmlType key, DatabaseType value) {
        if (this.isExistsInCache(cacheType, key)) {
            DatabaseType obj = this.getValueFromCache(cacheType, key);
            if (obj instanceof Collection) {
                return ((Collection)obj).contains(value);
            }
            return EqualsHelper.isEqualsNull(obj, value);
        }
        return false;
    }

    @Override
    public <CacheType> boolean isExistsInCache(Class<CacheType> cacheType) {
        return this.isEnabled() && this.values.get().containsKey(cacheType);
    }

    @Override
    public <CacheType, XmlType, DatabaseType> DatabaseType getValueFromCache(Class<CacheType> cacheType, XmlType key) {
        if (this.isEnabled() && this.values.get().containsKey(cacheType)) {
            return (DatabaseType)this.values.get().get(cacheType).get(key);
        }
        return null;
    }

    @Override
    public <XmlType, DatabaseType> DatabaseType getValueFromCache(String regExpClassName, XmlType key) {
        if (!this.isEnabled()) {
            return null;
        }
        for (Map.Entry<Class<?>, Map> entry : this.values.get().entrySet()) {
            if (!entry.getKey().getCanonicalName().matches(regExpClassName)) continue;
            return (DatabaseType)entry.getValue().get(key);
        }
        return null;
    }

    @Override
    public void clear() {
        this.values.get().clear();
    }

    @Override
    public <XmlType> void addServiceResultToCache(@NotNull XmlType key, @NotNull ServiceResult value) {
        if (this.isEnabled()) {
            for (Map.Entry<Class<?>, Object> entry : value.getObjects().entrySet()) {
                this.addToCache(entry.getKey(), key, entry.getValue());
            }
        }
    }

    @Override
    public List<?> getAllValues(Collection<Class<?>> cacheTypes) {
        ArrayList ret = new ArrayList();
        Map<Class<?>, Map> cacheMap = this.values.get();
        for (Class<?> cacheType : cacheTypes) {
            Map map = cacheMap.get(cacheType);
            ret.addAll(map.values());
        }
        return ret;
    }

    @Override
    public <CacheType> Map getAllValues(Class<CacheType> cacheType) {
        Map map = this.values.get().get(cacheType);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Set<Class<?>> getAllClasses() {
        return Collections.unmodifiableSet(this.values.get().keySet());
    }
}

