/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.impl;

import cz.datalite.dao.GenericDAO;
import cz.datalite.dao.impl.GenericDAOImpl;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public class GenericDAOFactory {
    public static <T, ID extends Serializable, DAO extends GenericDAO<T, ID>> DAO createDAO(ApplicationContext applicationContext, Class<T> entityClass, Class<ID> idClass, Class<DAO> daoClass) {
        final EntityManagerFactory entityManagerFactory = GenericDAOFactory.getEntityManagerFactory(applicationContext, daoClass);
        GenericDAOImpl impl = new GenericDAOImpl<T, ID>(entityClass){

            public EntityManager getEntityManager() {
                return EntityManagerFactoryUtils.doGetTransactionalEntityManager((EntityManagerFactory)entityManagerFactory, null);
            }
        };
        ProxyFactory result = new ProxyFactory();
        result.setTarget((Object)impl);
        result.setInterfaces(new Class[]{daoClass});
        return (DAO)((GenericDAO)result.getProxy());
    }

    private static EntityManagerFactory getEntityManagerFactory(ApplicationContext applicationContext, Class daoClass) {
        EntityManagerFactory entityManagerFactory = null;
        try {
            entityManagerFactory = (EntityManagerFactory)applicationContext.getBean("entityManagerFactory");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (entityManagerFactory == null) {
            Map beans = applicationContext.getBeansOfType(EntityManagerFactory.class);
            if (beans.isEmpty()) {
                throw new InstantiationError("Create default DAO for class '" + daoClass.getName() + "': No bean with name of 'entityManagerFactory' or type of 'javax.persistence.EntityManager' found.");
            }
            if (beans.size() > 1) {
                StringBuffer keys = new StringBuffer();
                for (String bean : beans.keySet()) {
                    keys.append(bean);
                    keys.append(",");
                }
                throw new InstantiationError("Create default DAO for class '" + daoClass.getName() + "': No bean with name of 'entityManagerFactory' and multiple beans of type 'javax.persistence.EntityManagerFactory' found: ' [" + keys.toString() + "]");
            }
            entityManagerFactory = (EntityManagerFactory)beans.values().iterator().next();
        }
        return entityManagerFactory;
    }
}

