/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql;

import cz.datalite.dao.plsql.FieldInfo;
import cz.datalite.dao.plsql.annotations.SqlField;
import cz.datalite.dao.plsql.helpers.ObjectHelper;
import cz.datalite.helpers.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;

public class FieldMaps {
    static final Object fieldsMapLocker = new Object();
    static Map<Class<?>, Map<String, FieldInfo>> fieldsMap = new HashMap();
    static boolean allowedHibernateAnnotations = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, FieldInfo> getFieldMaps(Class<?> entityClass) {
        Map<String, FieldInfo> fm = fieldsMap.get(entityClass);
        if (fm == null || fm.isEmpty()) {
            Object object = fieldsMapLocker;
            synchronized (object) {
                fm = FieldMaps.generateFieldMaps(entityClass);
                fieldsMap.put(entityClass, fm);
            }
        }
        return fm;
    }

    public static Map<String, FieldInfo> generateFieldMaps(Class<?> entityClass) {
        HashMap<String, FieldInfo> result = new HashMap<String, FieldInfo>();
        if (ObjectHelper.isBoolean(entityClass)) {
            result.put("b", new FieldInfo("b", Boolean.class));
        } else if (ObjectHelper.isNumeric(entityClass)) {
            result.put("n", new FieldInfo("n", Long.class));
        } else if (ObjectHelper.isString(entityClass)) {
            result.put("s", new FieldInfo("s", String.class));
        } else if (ObjectHelper.isDate(entityClass)) {
            result.put("d", new FieldInfo("d", Date.class));
        } else {
            for (Field field : ReflectionHelper.getAllFields(entityClass)) {
                FieldMaps.generateFieldMaps(result, field);
            }
        }
        return result;
    }

    public static void generateFieldMaps(Map<String, FieldInfo> result, Field field) {
        if (field.isAnnotationPresent(SqlField.class)) {
            SqlField sqlField = field.getAnnotation(SqlField.class);
            result.put(sqlField.value(), new FieldInfo(field.getName(), field.getType()));
        } else if (allowedHibernateAnnotations && field.isAnnotationPresent(Column.class)) {
            Column sqlField = field.getAnnotation(Column.class);
            result.put(sqlField.name(), new FieldInfo(field.getName(), field.getType()));
        }
    }

    public static void setAllowedHibernateAnnotations(boolean allowedHibernateAnnotations) {
        FieldMaps.allowedHibernateAnnotations = allowedHibernateAnnotations;
    }
}

