/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql;

import cz.datalite.stereotype.Autowired;
import cz.datalite.stereotype.DAO;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.DisposableSqlTypeValue;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

@DAO
public class SqlLobValueFactory {
    @Autowired
    LobHandler lobHandler;

    public DisposableSqlTypeValue createLobValue(Object content) {
        return new SqlLobValue(content, this.lobHandler.getLobCreator());
    }

    class SqlLobValue
    implements DisposableSqlTypeValue {
        private final LobCreator creator;
        private Object content;
        private int length;

        public void cleanup() {
            this.creator.close();
        }

        public SqlLobValue(Object content, LobCreator creator) {
            this.content = content;
            this.creator = creator;
            if (content instanceof byte[]) {
                this.length = ((byte[])content).length;
            } else if (content instanceof String) {
                this.length = ((String)content).length();
            } else if (content == null) {
                this.length = 0;
            } else {
                throw new IllegalArgumentException("Nepodporovan\u00fd type hodnoty [" + this.content.getClass().getName() + "]");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setTypeValue(PreparedStatement ps, int paramIndex, int sqlType, String typeName) throws SQLException {
            if (sqlType == 2004) {
                if (this.content instanceof byte[] || this.content == null) {
                    this.creator.setBlobAsBytes(ps, paramIndex, (byte[])this.content);
                    return;
                } else if (this.content instanceof String) {
                    this.creator.setBlobAsBytes(ps, paramIndex, ((String)this.content).getBytes());
                    return;
                } else {
                    if (!(this.content instanceof InputStream)) throw new IllegalArgumentException("Nepodporovan\u00fd type hodnoty [" + this.content.getClass().getName() + "]");
                    this.creator.setBlobAsBinaryStream(ps, paramIndex, (InputStream)this.content, this.length);
                }
                return;
            } else {
                if (sqlType != 2005) throw new IllegalArgumentException("\u0160patn\u00fd typ hodnoty. Podporovan\u00e9 typu jsou CLOB nebo BLOB");
                if (this.content instanceof String || this.content == null) {
                    this.creator.setClobAsString(ps, paramIndex, (String)this.content);
                    return;
                } else if (this.content instanceof InputStream) {
                    this.creator.setClobAsAsciiStream(ps, paramIndex, (InputStream)this.content, this.length);
                    return;
                } else {
                    if (!(this.content instanceof Reader)) throw new IllegalArgumentException("Nepodporovan\u00fd type hodnoty [" + this.content.getClass().getName() + "]");
                    this.creator.setClobAsCharacterStream(ps, paramIndex, (Reader)this.content, this.length);
                }
            }
        }
    }
}

