/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql;

import cz.datalite.dao.plsql.FieldInfo;
import cz.datalite.dao.plsql.FieldMaps;
import cz.datalite.dao.plsql.MergeType;
import cz.datalite.dao.plsql.StructConvertable;
import cz.datalite.dao.plsql.helpers.ObjectHelper;
import cz.datalite.helpers.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.sql.ARRAY;

public class StoredProcedureResult
extends HashMap<String, Object> {
    private Map<String, String> long2shortName;

    public StoredProcedureResult(Map<String, Object> original, Map<String, String> long2shortName) {
        super(original);
        this.long2shortName = long2shortName;
    }

    private String compressName(String original) {
        if (this.long2shortName.containsKey(original)) {
            return this.long2shortName.get(original);
        }
        String shortName = "S" + this.long2shortName.size();
        this.long2shortName.put(original, shortName);
        return shortName;
    }

    private <T> List<T> extractFromArray(Object[] array, Class<T> returnType) {
        if (array == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object v : array) {
            result.add(ObjectHelper.extractFromObject(v, returnType));
        }
        return result;
    }

    private <T> List<T> extractFromArray(Object obj, Class<T> itemType) {
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof ARRAY) {
            try {
                return this.extractFromArray((Object[])((ARRAY)obj).getArray(), itemType);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Chyba p\u0159i p\u0159evodu DB pole na JAVA pole", e);
            }
        }
        if (obj != null) {
            throw new IllegalStateException("N\u00e1vratov\u00e1 hodnota m\u00e1 \u0161patn\u00fd typ:" + obj.getClass());
        }
        return null;
    }

    public <T> T extract(String name, Class<T> returnType) {
        Object obj = this.get(name);
        return ObjectHelper.extractFromObject(obj, returnType);
    }

    public <T extends StructConvertable> T extractStruct(String name, Class<T> returnType) {
        Object obj = this.get(name);
        return (T)((StructConvertable)ObjectHelper.extractFromObject(obj, returnType));
    }

    public <T> List<T> extractArray(String name, Class<T> returnType) {
        Object obj = this.get(name);
        return this.extractFromArray(obj, returnType);
    }

    public <T> T extractRecord(String name, Class<T> returnType) {
        if (ObjectHelper.isBoolean(returnType)) {
            return (T)ObjectHelper.extractBoolean(this.get("o" + name + "." + "b"));
        }
        if (ObjectHelper.isNumeric(returnType)) {
            return ObjectHelper.extractFromObject(this.get("o" + name + "." + "n"), returnType);
        }
        if (ObjectHelper.isDate(returnType)) {
            return ObjectHelper.extractFromObject(this.get("o" + name + "." + "d"), returnType);
        }
        if (ObjectHelper.isString(returnType)) {
            return ObjectHelper.extractFromObject(this.get("o" + name + "." + "s"), returnType);
        }
        T result = ObjectHelper.newInstance(returnType);
        boolean found = this.extractRecord(name, result);
        return (T)(found ? result : null);
    }

    public <T> boolean extractRecord(String name, T returnValue) {
        boolean found = false;
        for (Map.Entry<String, FieldInfo> field : FieldMaps.getFieldMaps(returnValue.getClass()).entrySet()) {
            String parameterName = "o" + name + "." + field.getKey();
            Object value = null;
            if (this.containsKey(parameterName)) {
                value = this.get(parameterName);
                found = true;
            }
            ObjectHelper.setValue(field.getValue().getFieldName(), returnValue, ObjectHelper.extractFromObject(value, field.getValue().getType()));
        }
        return found;
    }

    private <T> void extractFromTable(Map<FieldInfo, List<?>> source, int index, T target) {
        for (FieldInfo fieldName : source.keySet()) {
            List<?> fieldData = source.get(fieldName);
            ObjectHelper.setValue(fieldName.getFieldName(), target, fieldData == null ? null : ObjectHelper.extractFromObject(fieldData.get(index), fieldName.getType()));
        }
    }

    private <T> void extractFromTable(String name, Class<T> returnType, Map<FieldInfo, List<?>> target) {
        for (Map.Entry<String, FieldInfo> field : FieldMaps.getFieldMaps(returnType).entrySet()) {
            String parameterName = this.compressName(name + "_" + field.getKey());
            target.put(field.getValue(), this.extractFromArray(this.get(parameterName), field.getValue().getType()));
        }
    }

    public <T> List<T> extractTable(String name, Class<T> returnType) {
        FieldInfo fi;
        ArrayList<Object> result = new ArrayList<Object>();
        Long count = ObjectHelper.extractLong(this.get(name + "_COUNT"));
        if (count == null) {
            count = 0L;
        }
        HashMap dataFromDB = new HashMap();
        this.extractFromTable("o" + name, returnType, dataFromDB);
        if (dataFromDB.size() == 1 && (fi = (FieldInfo)dataFromDB.keySet().toArray()[0]).isPrimitive()) {
            for (Object value : (List)dataFromDB.get(fi)) {
                result.add(ObjectHelper.extractFromObject(value, fi.getType()));
            }
            return result;
        }
        int i = 0;
        while ((long)i < count) {
            T record = ObjectHelper.newInstance(returnType);
            this.extractFromTable(dataFromDB, i, record);
            result.add(record);
            ++i;
        }
        return result;
    }

    public <T> void extractTable(String name, Class<T> returnType, List<T> target, MergeType mergeType) {
        List<T> novySeznam = this.extractTable(name, returnType);
        if (mergeType == MergeType.REPLACE) {
            target.clear();
        }
        if (novySeznam != null && !novySeznam.isEmpty()) {
            if (mergeType == MergeType.ALL) {
                target.addAll(novySeznam);
            } else if (mergeType == MergeType.NEW) {
                for (T item : novySeznam) {
                    if (target.contains(item)) continue;
                    target.add(item);
                }
            } else {
                ArrayList<T> newTarget = new ArrayList<T>(target);
                target.clear();
                for (T item : novySeznam) {
                    if (!newTarget.contains(item)) {
                        target.add(item);
                        continue;
                    }
                    if (mergeType != MergeType.MERGE && mergeType != MergeType.SYNCHRONIZE) continue;
                    int index = newTarget.indexOf(item);
                    Object old = newTarget.get(index);
                    newTarget.remove(index);
                    target.add(old);
                    for (Field field : ReflectionHelper.getAllFields(returnType)) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        ObjectHelper.setValue(field.getName(), old, ObjectHelper.getValue(field.getName(), item));
                    }
                }
                if (mergeType == MergeType.MERGE && !newTarget.isEmpty()) {
                    target.addAll(newTarget);
                }
            }
        } else if (mergeType == MergeType.SYNCHRONIZE) {
            target.clear();
        }
    }

    public Boolean extractBoolean(String name) {
        return this.extractRecord(name, Boolean.class);
    }

    public <T> T extractResult(Class<T> returnType) {
        Object obj = this.get("RETURN_VALUE");
        return ObjectHelper.extractFromObject(obj, returnType);
    }

    public <T extends StructConvertable> T extractResultStruct(Class<T> returnType) {
        return this.extractStruct("RETURN_VALUE", returnType);
    }

    public <T> List<T> extractResultArray(Class<T> returnType) {
        Object obj = this.get("RETURN_VALUE");
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof ARRAY) {
            try {
                return this.extractFromArray((Object[])((ARRAY)obj).getArray(), returnType);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Chyba p\u0159i p\u0159evodu DB pole na JAVA pole", e);
            }
        }
        if (obj != null) {
            throw new IllegalStateException("N\u00e1vratov\u00e1 hodnota m\u00e1 \u0161patn\u00fd typ:" + obj.getClass());
        }
        return null;
    }

    public <T> List<T> extractResultTable(Class<T> returnType) {
        return this.extractTable("RETURN_VALUE", returnType);
    }

    public <T> T extractResultRecord(Class<T> returnType) {
        return this.extractRecord("RETURN_VALUE", returnType);
    }

    public Date getDate(String name) {
        return this.extract(name, Date.class);
    }

    public String getString(String name) {
        return this.extract(name, String.class);
    }

    public Long getLong(String name) {
        return this.extract(name, Long.class);
    }

    public <T> T getResultValue(Class<T> type) {
        return this.extract("RETURN_VALUE", type);
    }

    public BigInteger getBigInteger(String name) {
        return this.extract(name, BigInteger.class);
    }

    public Integer getInteger(String name) {
        return this.extract(name, Integer.class);
    }
}

