/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql.helpers;

import cz.datalite.helpers.StringHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class EnumHelper {
    private EnumHelper() {
    }

    public static Object[] getEnumValues(Class enumClass) {
        try {
            Method m = enumClass.getDeclaredMethod("values", new Class[0]);
            return (Object[])m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getEnumValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            Method m = value.getClass().getDeclaredMethod("getValue", new Class[0]);
            return (String)m.invoke(value, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T getEnumValue(Class<T> enumType, String value) {
        try {
            for (Method m : enumType.getDeclaredMethods()) {
                if (!StringHelper.isEquals((String)m.getName(), (String)"fromValue") && !StringHelper.isEquals((String)m.getName(), (String)"getByStringValue")) continue;
                return (T)m.invoke(null, value);
            }
            if (!StringHelper.isNull((String)value)) {
                for (Object o : EnumHelper.getEnumValues(enumType)) {
                    if (!StringHelper.isEquals((String)EnumHelper.getEnumName(o), (String)value)) continue;
                    return (T)o;
                }
                throw new IllegalArgumentException("Neexistuje method fromValue ve t\u0159\u00edd\u011b " + enumType.getName());
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getEnumName(Object value) {
        if (value == null) {
            return null;
        }
        return ((Enum)value).name();
    }
}

