/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql.helpers;

import cz.datalite.dao.plsql.FieldInfo;
import cz.datalite.dao.plsql.StructConvertable;
import cz.datalite.dao.plsql.helpers.EnumHelper;
import cz.datalite.helpers.BooleanHelper;
import cz.datalite.helpers.DateHelper;
import cz.datalite.helpers.ReflectionHelper;
import cz.datalite.helpers.StringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.sql.STRUCT;
import org.hibernate.proxy.HibernateProxyHelper;

public final class ObjectHelper {
    private ObjectHelper() {
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Method getFieldGetter(Class aClass, Field field) {
        if (aClass == null) {
            throw new IllegalArgumentException("Class aClass is null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field argument is null");
        }
        String fieldName = field.getName();
        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return aClass.getMethod("get" + fieldName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return aClass.getMethod("is" + fieldName, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                try {
                    return aClass.getMethod("get" + methodName, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        return aClass.getMethod("is" + methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e3) {
                        if (aClass.getSuperclass() != Object.class) {
                            return ObjectHelper.getFieldGetter(aClass.getSuperclass(), field);
                        }
                    }
                }
                catch (NullPointerException e4) {
                    e.printStackTrace();
                }
                return null;
            }
        }
    }

    public static Method getFieldGetter(Class aClass, String field) {
        if (aClass == null) {
            throw new IllegalArgumentException("Class aClass is null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field argument is null");
        }
        String methodName = field.substring(0, 1).toUpperCase() + field.substring(1);
        try {
            return aClass.getMethod("get" + field, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return aClass.getMethod("is" + field, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                try {
                    return aClass.getMethod("get" + methodName, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        return aClass.getMethod("is" + methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e3) {
                        if (aClass.getSuperclass() != Object.class) {
                            return ObjectHelper.getFieldGetter(aClass.getSuperclass(), field);
                        }
                    }
                }
                catch (NullPointerException e4) {
                    e.printStackTrace();
                }
                return null;
            }
        }
    }

    public static Method getFieldSetter(Class aClass, Field field) {
        if (aClass == null) {
            throw new IllegalArgumentException("Class aClass is null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field argument is null");
        }
        String fieldName = field.getName();
        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return aClass.getMethod("set" + fieldName, field.getType());
        }
        catch (NoSuchMethodException e) {
            try {
                return aClass.getMethod("set" + methodName, field.getType());
            }
            catch (NoSuchMethodException e1) {
                if (aClass.getSuperclass() != Object.class) {
                    return ObjectHelper.getFieldSetter(aClass.getSuperclass(), field);
                }
            }
            catch (NullPointerException e2) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(String fieldName, Object obj) {
        if (obj == null) {
            return null;
        }
        int dot = fieldName.indexOf(".");
        if (dot > 0) {
            Object value = ObjectHelper.getValue(fieldName.substring(0, dot), obj);
            return value == null ? null : ObjectHelper.getValue(fieldName.substring(dot + 1), value);
        }
        Class clazz = null;
        clazz = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        Method m = ObjectHelper.getFieldGetter(clazz, fieldName);
        if (m != null) {
            return m.invoke(obj, new Object[0]);
        }
        Field field = ObjectHelper.getDeclaredField(clazz, fieldName);
        boolean f = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(obj);
            field.setAccessible(f);
            return object;
        }
        catch (Throwable throwable) {
            try {
                field.setAccessible(f);
                throw throwable;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Missing field '" + fieldName + "' in '" + clazz + "'");
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can`t access field '" + fieldName + "' in '" + clazz + "'");
            }
        }
    }

    public static <T> T getValue(String fieldName, Object obj, Class<T> returnType) {
        return ObjectHelper.extractFromObject(ObjectHelper.getValue(fieldName, obj), returnType);
    }

    private static Field getDeclaredField(Class clazz, String name) throws NoSuchFieldException {
        for (Field field : ReflectionHelper.getAllFields((Class)clazz)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new NoSuchFieldException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(String fieldName, Object obj, Object value) {
        if (obj == null) {
            return;
        }
        try {
            Class clazz = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
            int dot = fieldName.indexOf(".");
            if (dot > 0) {
                ObjectHelper.setValue(fieldName.substring(dot + 1), ObjectHelper.getValue(fieldName.substring(0, dot), obj), value);
                return;
            }
            Field field = ObjectHelper.getDeclaredField(clazz, fieldName);
            Method m = ObjectHelper.getFieldSetter(field.getDeclaringClass(), field);
            if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
                value = ObjectHelper.extractFromObject(value, field.getType());
            }
            if (m != null) {
                m.invoke(obj, value);
            }
            boolean f = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(obj, value);
            }
            finally {
                field.setAccessible(f);
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T extractFromObject(Object value, Class<T> returnType) {
        if (value instanceof STRUCT) {
            try {
                StructConvertable sc = (StructConvertable)returnType.newInstance();
                return (T)ObjectHelper.extractFromStructure(value, sc);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        if (returnType == Integer.class || returnType == Integer.TYPE) {
            return (T)ObjectHelper.extractInteger(value);
        }
        if (returnType == Long.class || returnType == Long.TYPE) {
            return (T)ObjectHelper.extractLong(value);
        }
        if (returnType == Double.class || returnType == Double.TYPE) {
            return (T)ObjectHelper.extractDouble(value);
        }
        if (returnType == BigDecimal.class) {
            return (T)ObjectHelper.extractBigDecimal(value);
        }
        if (returnType == Boolean.class || returnType == Boolean.TYPE) {
            return (T)ObjectHelper.extractBoolean(value);
        }
        if (returnType == String.class) {
            return (T)ObjectHelper.extractString(value);
        }
        if (returnType == BigInteger.class) {
            return (T)ObjectHelper.extractBigInteger(value);
        }
        if (returnType == Date.class) {
            return (T)ObjectHelper.extractDate(value);
        }
        if (returnType.isEnum()) {
            return EnumHelper.getEnumValue(returnType, ObjectHelper.extractString(value));
        }
        return (T)value;
    }

    public static String extractString(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "A" : "N";
        }
        if (value instanceof Date) {
            return DateHelper.dateToString((Date)((Date)value), (String)"MM/dd/yyyy HH:mm:ss");
        }
        return value != null ? String.valueOf(value) : null;
    }

    public static Long extractLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof String) {
            return !StringHelper.isNull((String)((String)value)) ? Long.valueOf(Long.parseLong(ObjectHelper.removeDot((String)value))) : null;
        }
        if (value instanceof Double) {
            return Double.valueOf(Double.parseDouble(String.valueOf(value))).longValue();
        }
        return value != null ? Long.valueOf(Long.parseLong(String.valueOf(value))) : null;
    }

    public static Double extractDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return (double)((Integer)value);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof String) {
            return !StringHelper.isNull((String)((String)value)) ? Double.valueOf(Double.parseDouble((String)value)) : null;
        }
        return value != null ? Double.valueOf(Double.parseDouble(String.valueOf(value))) : null;
    }

    public static Integer extractInteger(Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return !StringHelper.isNull((String)((String)value)) ? Integer.valueOf(Integer.parseInt(ObjectHelper.removeDot((String)value))) : null;
        }
        if (value instanceof Double) {
            return Double.valueOf(Double.parseDouble(String.valueOf(value))).intValue();
        }
        return value != null ? Integer.valueOf(Integer.parseInt(String.valueOf(value))) : null;
    }

    public static BigDecimal extractBigDecimal(Object value) {
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof String) {
            return !StringHelper.isNull((String)((String)value)) ? new BigDecimal((String)value) : null;
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        return value != null ? new BigDecimal(String.valueOf(value)) : null;
    }

    public static BigInteger extractBigInteger(Object value) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Integer) {
            return BigInteger.valueOf(((Integer)value).intValue());
        }
        if (value instanceof String) {
            return !StringHelper.isNull((String)((String)value)) ? new BigInteger((String)value) : null;
        }
        if (value instanceof Double) {
            return new BigInteger(ObjectHelper.extractString(value));
        }
        return value != null ? new BigInteger(String.valueOf(value)) : null;
    }

    public static Boolean extractBoolean(Object value) {
        if (value instanceof Long) {
            return (Long)value != 0L;
        }
        if (value instanceof BigDecimal) {
            return !BigDecimal.ZERO.equals(value);
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return BooleanHelper.isTrue((String)((String)value));
        }
        return value != null ? Boolean.valueOf(BooleanHelper.isTrue((String)String.valueOf(value))) : null;
    }

    public static Date extractDate(Object value) {
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Integer) {
            return new Date(((Integer)value).longValue());
        }
        if (value instanceof String) {
            return DateHelper.fromString((String)((String)value));
        }
        if (value instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)value).toGregorianCalendar().getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isNumeric(FieldInfo fieldInfo) {
        return ObjectHelper.isNumeric(fieldInfo.getType());
    }

    public static boolean isNumeric(Class<?> type) {
        return type == Integer.class || type == Long.class || type == BigDecimal.class || type == Integer.TYPE || type == Long.TYPE;
    }

    public static boolean isDate(FieldInfo fieldInfo) {
        return ObjectHelper.isDate(fieldInfo.getType());
    }

    public static boolean isDate(Class<?> type) {
        return type == Date.class;
    }

    public static boolean isString(Class<?> type) {
        return type == String.class;
    }

    public static <E extends StructConvertable> E extractFromStructure(Object source, E target) {
        if (target == null) {
            throw new IllegalArgumentException("Nen\u00ed ur\u010den c\u00edlov\u00fd objekt");
        }
        if (source instanceof STRUCT) {
            try {
                target.setStructureAttributes(((STRUCT)source).getAttributes());
                return target;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Zdrojov\u00fd objekt nen\u00ed typu STRUCT");
    }

    public static <T> T[] asArray(T ... values) {
        return values;
    }

    private static String removeDot(String original) {
        return original != null && original.endsWith(".0") ? original.substring(0, original.indexOf(".")) : original;
    }
}

