/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql.impl;

import cz.datalite.dao.plsql.FieldInfo;
import cz.datalite.dao.plsql.FieldMaps;
import cz.datalite.dao.plsql.MergeType;
import cz.datalite.dao.plsql.SqlLobValueFactory;
import cz.datalite.dao.plsql.StoredProcedureInvoker;
import cz.datalite.dao.plsql.StoredProcedureResult;
import cz.datalite.dao.plsql.StructConvertable;
import cz.datalite.dao.plsql.helpers.ObjectHelper;
import cz.datalite.dao.plsql.impl.RecordInOutParameter;
import cz.datalite.dao.plsql.impl.RecordInParameter;
import cz.datalite.dao.plsql.impl.RecordOutParameter;
import cz.datalite.dao.plsql.impl.RecordParameter;
import cz.datalite.helpers.StringHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlInOutParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.object.StoredProcedure;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

class AbstractStoredProcedureInvoker
extends StoredProcedure
implements StoredProcedureInvoker {
    private static final Logger PLSQL_LOGGER = LoggerFactory.getLogger((String)(AbstractStoredProcedureInvoker.class + ".plsql"));
    private Map<String, Object> inputs = new HashMap<String, Object>();
    private SqlLobValueFactory sqlLobValueFactory;
    private String databaseSchema;
    private boolean wrapNeed = false;
    private EntityManager entityManager;
    private Map<String, String> long2shortName = new HashMap<String, String>();

    public AbstractStoredProcedureInvoker(DataSource dataSource, SqlLobValueFactory sqlLobValueFactory, String databaseSchema, EntityManager entityManager) {
        super(dataSource, "");
        this.entityManager = entityManager;
        this.sqlLobValueFactory = sqlLobValueFactory;
        this.databaseSchema = databaseSchema;
    }

    public AbstractStoredProcedureInvoker(DataSource dataSource, String name, SqlLobValueFactory sqlLobValueFactory, String databaseSchema, EntityManager entityManager) {
        this(dataSource, name, sqlLobValueFactory, databaseSchema, entityManager, null);
    }

    public AbstractStoredProcedureInvoker(DataSource dataSource, String name, int resultType, SqlLobValueFactory sqlLobValueFactory, String databaseSchema, EntityManager entityManager) {
        this(dataSource, name, resultType, sqlLobValueFactory, databaseSchema, entityManager, null);
    }

    public AbstractStoredProcedureInvoker(DataSource dataSource, SqlLobValueFactory sqlLobValueFactory, String databaseSchema, EntityManager entityManager, NativeJdbcExtractor extractor) {
        super(dataSource, "");
        this.entityManager = entityManager;
        this.sqlLobValueFactory = sqlLobValueFactory;
        this.databaseSchema = databaseSchema;
        this.getJdbcTemplate().setNativeJdbcExtractor(extractor);
    }

    public AbstractStoredProcedureInvoker(DataSource dataSource, String name, SqlLobValueFactory sqlLobValueFactory, String databaseSchema, EntityManager entityManager, NativeJdbcExtractor extractor) {
        this(dataSource, sqlLobValueFactory, databaseSchema, entityManager, extractor);
        this.setName(name);
    }

    public AbstractStoredProcedureInvoker(DataSource dataSource, String name, int resultType, SqlLobValueFactory sqlLobValueFactory, String databaseSchema, EntityManager entityManager, NativeJdbcExtractor extractor) {
        this(dataSource, name, sqlLobValueFactory, databaseSchema, entityManager, extractor);
        this.declareReturnParameter(resultType);
    }

    private boolean isParameterFounded(String name) {
        for (SqlParameter parameter : this.getDeclaredParameters()) {
            if (!name.equalsIgnoreCase(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    private SqlParameter declareOutParameter(SqlParameter param) {
        String name = param.getName();
        if (this.isParameterFounded(name)) {
            throw new IllegalStateException("V\u00fdstupn\u00ed parameter '" + name + "' je ji\u017e definov\u00e1n");
        }
        super.declareParameter(param);
        return param;
    }

    private Connection getNativeConnection() throws SQLException {
        Connection con = DataSourceUtils.getConnection((DataSource)this.getJdbcTemplate().getDataSource());
        return this.getJdbcTemplate().getNativeJdbcExtractor() != null ? this.getJdbcTemplate().getNativeJdbcExtractor().getNativeConnection(con) : con;
    }

    private SqlParameter createInputParameter(SqlParameter sqlParameter, Object value) {
        Object newValue = value;
        int type = sqlParameter.getSqlType();
        String name = sqlParameter.getName();
        if (this.isParameterFounded(name)) {
            throw new IllegalStateException("Vstupn\u00ed parameter '" + name + "' je ji\u017e definov\u00e1n");
        }
        if (value != null) {
            newValue = value instanceof Boolean && type == 12 ? ((Boolean)value != false ? "A" : "N") : (value instanceof Enum ? ((Enum)value).name() : value);
        }
        this.inputs.put(name, newValue);
        return sqlParameter;
    }

    private SqlParameter declareParameter(SqlParameter sqlParameter, Object value) {
        this.declareParameter(this.createInputParameter(sqlParameter, value));
        return sqlParameter;
    }

    @Override
    public List<SqlParameter> getDeclaredParameters() {
        return super.getDeclaredParameters();
    }

    @Override
    public void setName(String name) {
        this.setSql(name);
    }

    @Override
    public SqlParameter declareReturnParameter(int type) {
        if (this.isParameterFounded("RETURN_VALUE")) {
            throw new IllegalStateException("N\u00e1vratov\u00fd parametr je ji\u017e definov\u00e1n");
        }
        this.setFunction(true);
        return this.declareOutParameter("RETURN_VALUE", type);
    }

    @Override
    public SqlParameter declareReturnStructParameter(String typeName) {
        if (this.isParameterFounded("RETURN_VALUE")) {
            throw new IllegalStateException("N\u00e1vratov\u00fd parametr je ji\u017e definov\u00e1n");
        }
        this.setFunction(true);
        return this.declareOutParameter((SqlParameter)new SqlOutParameter("RETURN_VALUE", 2002, typeName));
    }

    @Override
    public SqlParameter declareReturnArrayParameter(String typeName) {
        if (this.isParameterFounded("RETURN_VALUE")) {
            throw new IllegalStateException("N\u00e1vratov\u00fd parametr je ji\u017e definov\u00e1n");
        }
        this.setFunction(true);
        return this.declareOutParameter((SqlParameter)new SqlOutParameter("RETURN_VALUE", 2003, typeName));
    }

    @Override
    public <T> SqlParameter declareReturnRecordParameter(String dbType, Class<T> entityClass) {
        if (this.isParameterFounded("RETURN_VALUE")) {
            throw new IllegalStateException("N\u00e1vratov\u00fd parametr je ji\u017e definov\u00e1n");
        }
        this.setFunction(true);
        return this.declareOutRecordParameter("RETURN_VALUE", dbType, entityClass);
    }

    @Override
    public <T> SqlParameter declareReturnTableParameter(String dbType, Class<T> entityClass) {
        if (this.isParameterFounded("RETURN_VALUE")) {
            throw new IllegalStateException("N\u00e1vratov\u00fd parametr je ji\u017e definov\u00e1n");
        }
        this.setFunction(true);
        return this.declareOutTableParameter("RETURN_VALUE", dbType, entityClass);
    }

    @Override
    public SqlParameter declareReturnBooleanParameter() {
        return this.declareReturnRecordParameter("boolean", Boolean.class);
    }

    @Override
    public SqlParameter declareOutParameter(String name, int type) {
        return this.declareOutParameter((SqlParameter)new SqlOutParameter(name, type));
    }

    @Override
    public SqlParameter declareOutStructParameter(String name, String dbType) {
        return this.declareOutParameter((SqlParameter)new SqlOutParameter(name, 2002, dbType));
    }

    @Override
    public SqlParameter declareOutArrayParameter(String name, String dbType) {
        return this.declareOutParameter((SqlParameter)new SqlOutParameter(name, 2003, dbType));
    }

    @Override
    public <T> SqlParameter declareOutRecordParameter(String name, String dbType, Class<T> entityClass) {
        this.wrapNeed = true;
        return this.declareOutParameter((SqlParameter)new RecordOutParameter<T>(name, entityClass, name, dbType));
    }

    @Override
    public SqlParameter declareOutBooleanParameter(String name) {
        return this.declareOutRecordParameter(name, "boolean", Boolean.class);
    }

    @Override
    public <T> SqlParameter declareOutTableParameter(String name, String dbType, Class<T> entityClass) {
        this.wrapNeed = true;
        return this.declareOutParameter((SqlParameter)new RecordOutParameter<T>(name, entityClass, name, dbType, true));
    }

    public SqlParameter declareInOutParameter(String name, int type, Object value) {
        Object v = value;
        if (type == 2005 || type == 2004) {
            v = this.sqlLobValueFactory.createLobValue(value);
        } else if (type == 16) {
            type = 12;
        } else if (type == 2003 || type == 2002) {
            throw new UnsupportedOperationException();
        }
        return this.declareParameter((SqlParameter)new SqlInOutParameter(name, type), v);
    }

    public <E extends StructConvertable> SqlParameter declareInOutStructParameter(String name, String type, E value) {
        try {
            STRUCT struct = null;
            if (value != null) {
                StructDescriptor descriptor = StructDescriptor.createDescriptor((String)type, (Connection)this.getNativeConnection());
                struct = new STRUCT(descriptor, this.getNativeConnection(), value.getStructureAttributes());
            }
            return this.declareParameter((SqlParameter)new SqlInOutParameter(name, 2002, type), struct);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> SqlParameter declareInOutArrayParameter(String name, String type, List<T> value) {
        try {
            ARRAY array = null;
            if (value != null) {
                ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)type, (Connection)this.getNativeConnection());
                array = new ARRAY(descriptor, this.getNativeConnection(), (Object)value.toArray());
            }
            return this.declareParameter((SqlParameter)new SqlInOutParameter(name, 2003, type), array);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> SqlParameter declareInOutRecordParameter(String name, String dbType, Class<T> entityClass, T value) {
        this.wrapNeed = true;
        return this.declareParameter((SqlParameter)new RecordInOutParameter<T>(name, entityClass, name, dbType), value);
    }

    @Override
    public SqlParameter declareInOutNullParameter(String name, int type) {
        return this.declareInOutParameter(name, type, (Object)null);
    }

    @Override
    public SqlParameter declareInOutBooleanParameter(String name, Boolean value) {
        return this.declareInOutRecordParameter(name, "boolean", Boolean.class, value);
    }

    @Override
    public <T> SqlParameter declareInOutTableParameter(String name, String dbType, Class<T> entityClass, List<T> value) {
        this.wrapNeed = true;
        return this.declareParameter((SqlParameter)new RecordInOutParameter<T>(name, entityClass, name, dbType, true), value);
    }

    public SqlParameter setParameter(String name, int type, Object value) {
        Object v = value;
        if (type == 2002 || type == 2003) {
            throw new UnsupportedOperationException();
        }
        if (type == 2005 || type == 2004) {
            v = this.sqlLobValueFactory.createLobValue(value);
        } else if (type == 16) {
            type = 12;
        }
        return this.declareParameter(new SqlParameter(name, type), v);
    }

    @Override
    public <E extends StructConvertable> SqlParameter setStructParameter(String name, String typeName, E value) {
        try {
            STRUCT struct = null;
            if (value != null) {
                StructDescriptor descriptor = StructDescriptor.createDescriptor((String)typeName, (Connection)this.getNativeConnection());
                struct = new STRUCT(descriptor, this.getNativeConnection(), value.getStructureAttributes());
            }
            return this.declareParameter(new SqlParameter(name, 2002, typeName), struct);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public <E> SqlParameter setArrayParameter(String name, String typeName, List<E> value) {
        try {
            ARRAY array = null;
            if (value != null) {
                ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)typeName, (Connection)this.getNativeConnection());
                array = new ARRAY(descriptor, this.getNativeConnection(), (Object)value.toArray());
            }
            return this.declareParameter(new SqlParameter(name, 2003, typeName), array);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> SqlParameter setRecordParameter(String name, String dbType, Class<T> entityClass, T value) {
        this.wrapNeed = true;
        return this.declareParameter(new RecordInParameter<T>(name, entityClass, name, dbType), value);
    }

    @Override
    public SqlParameter setNullParameter(String name, int type) {
        return this.setParameter(name, type, (Object)null);
    }

    @Override
    public SqlParameter setBooleanParameter(String name, Boolean value) {
        return this.setRecordParameter(name, "boolean", Boolean.class, value);
    }

    @Override
    public <T> SqlParameter setTableParameter(String name, String dbType, Class<T> entityClass, List<T> value) {
        this.wrapNeed = true;
        return this.declareParameter(new RecordInParameter<T>(name, entityClass, name, dbType, true), value);
    }

    @Override
    public <T> T getResult(Class<T> returnType) {
        if (!this.isFunction()) {
            throw new IllegalStateException("Volan\u00fd DB objekt nen\u00ed funkce");
        }
        return this.execute().extractResult(returnType);
    }

    @Override
    public <T extends StructConvertable> T getResultStruct(Class<T> returnType) {
        if (!this.isFunction()) {
            throw new IllegalStateException("Volan\u00fd DB objekt nen\u00ed funkce");
        }
        return (T)((StructConvertable)this.execute().extractResult(returnType));
    }

    @Override
    public <T> List<T> getResultArray(Class<T> returnType) {
        if (!this.isFunction()) {
            throw new IllegalStateException("Volan\u00fd objekt nen\u00ed funkce");
        }
        return this.execute().extractResultArray(returnType);
    }

    @Override
    public <T> T getResultRecord(Class<T> returnType) {
        if (!this.isFunction()) {
            throw new IllegalStateException("Volan\u00fd objekt nen\u00ed funkce");
        }
        return this.execute().extractRecord("RETURN_VALUE", returnType);
    }

    @Override
    public Boolean isResultBoolean() {
        return this.getResultRecord(Boolean.class);
    }

    @Override
    public <T> List<T> getResultTable(Class<T> returnType) {
        if (!this.isFunction()) {
            throw new IllegalStateException("Volan\u00fd objekt nen\u00ed funkce");
        }
        return this.execute().extractTable("RETURN_VALUE", returnType);
    }

    @Override
    @Deprecated
    public <T> T extractResult(StoredProcedureResult resultMap, Class<T> returnType) {
        return resultMap.extractResult(returnType);
    }

    @Override
    @Deprecated
    public <T> List<T> extractResultArray(StoredProcedureResult resultMap, Class<T> returnType) {
        return resultMap.extractResultArray(returnType);
    }

    @Override
    @Deprecated
    public <T> List<T> extractResultTable(StoredProcedureResult resultMap, Class<T> returnType) {
        return resultMap.extractResultTable(returnType);
    }

    @Override
    @Deprecated
    public StoredProcedureResult execute() {
        return this.executeIndex();
    }

    private void generateWrappedQuery(boolean named) {
        StringBuilder sb = new StringBuilder();
        sb.append("declare \n");
        sb.append(" ob char ;\n");
        this.generateDeclarePlSqlVariables(sb);
        ArrayList<SqlParameter> newInputParameter = new ArrayList<SqlParameter>();
        ArrayList<SqlParameter> newOutputParameter = new ArrayList<SqlParameter>();
        sb.append("begin\n");
        this.generateUsingVariables(sb, newInputParameter, true);
        this.generateCall(sb, named);
        this.generateUsingVariables(sb, newOutputParameter, false);
        sb.append("end ;\n");
        this.generateNewParameterList(newInputParameter, newOutputParameter, new ArrayList<SqlParameter>(this.getDeclaredParameters()));
        this.setName(sb.toString());
        this.setSqlReadyForUse(true);
    }

    private void generateNewParameterList(List<SqlParameter> newInputParameter, List<SqlParameter> newOutputParameter, List<SqlParameter> olds) {
        this.getDeclaredParameters().clear();
        if (newInputParameter != null && !newInputParameter.isEmpty()) {
            this.getDeclaredParameters().addAll(newInputParameter);
        }
        ListIterator<SqlParameter> oldsIt = olds.listIterator();
        while (oldsIt.hasNext()) {
            SqlParameter next = oldsIt.next();
            if (next instanceof RecordParameter) continue;
            this.getDeclaredParameters().add(next);
            oldsIt.remove();
        }
        if (newOutputParameter != null && !newOutputParameter.isEmpty()) {
            this.getDeclaredParameters().addAll(newOutputParameter);
        }
        for (SqlParameter sqlParameter : olds) {
            if (!(sqlParameter instanceof RecordParameter) || !((RecordParameter)sqlParameter).isInput()) continue;
            this.inputs.remove(sqlParameter.getName());
        }
    }

    private void generateCall(StringBuilder query, boolean named) {
        if (!StringHelper.isNull((String)this.getSql())) {
            boolean first = true;
            for (SqlParameter sqlParameter : this.getDeclaredParameters()) {
                if (first) {
                    if (sqlParameter instanceof RecordParameter) {
                        if (this.isFunction()) {
                            query.append(((RecordParameter)sqlParameter).getVariableName()).append(" := ");
                        }
                    } else if (this.isFunction()) {
                        query.append(" ? := ");
                    }
                    query.append(this.getSql());
                    if (!this.isFunction() || this.getDeclaredParameters().size() > 1) {
                        query.append("(");
                    }
                    if (!this.isFunction()) {
                        if (named) {
                            query.append(sqlParameter.getName()).append("=>");
                        }
                        if (sqlParameter instanceof RecordParameter) {
                            query.append(((RecordParameter)sqlParameter).getVariableName()).append(", ");
                        } else {
                            query.append("?, ");
                        }
                    }
                    first = false;
                    continue;
                }
                if (sqlParameter instanceof RecordParameter) {
                    if (named) {
                        query.append(sqlParameter.getName()).append("=>");
                    }
                    query.append(((RecordParameter)sqlParameter).getVariableName()).append(", ");
                    continue;
                }
                if (named) {
                    query.append(sqlParameter.getName()).append("=>");
                }
                query.append("?, ");
            }
            if (first) {
                query.append(this.getSql());
            } else {
                if (", ".equals(query.substring(query.length() - 2))) {
                    query.delete(query.length() - 2, query.length());
                }
                if (!this.isFunction() || this.getDeclaredParameters().size() > 1) {
                    query.append(")");
                }
            }
            query.append(";\n");
        }
    }

    private void generateDeclarePlSqlVariables(StringBuilder query) {
        for (SqlParameter sqlParameter : this.getDeclaredParameters()) {
            if (!(sqlParameter instanceof RecordParameter)) continue;
            RecordParameter parameter = (RecordParameter)sqlParameter;
            query.append(parameter.getVariableName()).append(" ").append(parameter.getDatabaseType()).append(" ;\n");
            if (!parameter.isArray() || !parameter.isOutput()) continue;
            this.generateDeclareArrayVariables(query, parameter);
        }
    }

    private String compressName(String original) {
        if (this.long2shortName.containsKey(original)) {
            return this.long2shortName.get(original);
        }
        String shortName = "S" + this.long2shortName.size();
        this.long2shortName.put(original, shortName);
        return shortName;
    }

    private Set<Map.Entry<String, FieldInfo>> getFieldEntrySets(Class entityClass) {
        return FieldMaps.getFieldMaps(entityClass).entrySet();
    }

    private void generateDeclareArrayVariables(StringBuilder query, RecordParameter parameter) {
        for (Map.Entry<String, FieldInfo> field : this.getFieldEntrySets(parameter.getTargetEntity())) {
            String variableName = this.compressName(parameter.getVariableName() + "_" + field.getKey());
            query.append(variableName).append(" ");
            if (ObjectHelper.isNumeric(field.getValue())) {
                query.append(" ").append(this.getDatabaseSchema()).append(".NUMBER_TABLE := ").append(this.getDatabaseSchema()).append(".NUMBER_TABLE() ");
            } else if (ObjectHelper.isDate(field.getValue())) {
                query.append(" ").append(this.getDatabaseSchema()).append(".DATE_TABLE := ").append(this.getDatabaseSchema()).append(".DATE_TABLE() ");
            } else {
                query.append(" ").append(this.getDatabaseSchema()).append(".VARCHAR_TABLE := ").append(this.getDatabaseSchema()).append(".VARCHAR_TABLE() ");
            }
            query.append(" ;\n");
        }
    }

    private void generateUsingVariables(StringBuilder query, List<SqlParameter> newParameters, boolean load) {
        for (SqlParameter next : this.getDeclaredParameters()) {
            RecordParameter parameter;
            if (!(next instanceof RecordParameter) || (!(parameter = (RecordParameter)next).isInput() || !load) && (!parameter.isOutput() || load)) continue;
            this.generateUsingVariables(query, parameter, newParameters, load);
        }
    }

    private void generateUsingVariables(StringBuilder query, RecordParameter parameter, List<SqlParameter> newParameterList, boolean load) {
        if (parameter.isArray()) {
            this.generateUsingArrayVariables(query, parameter, newParameterList, load);
            return;
        }
        Object sourceValue = load ? this.inputs.get(parameter.getVariableName()) : null;
        for (Map.Entry<String, FieldInfo> field : this.getFieldEntrySets(parameter.getTargetEntity())) {
            String variableName;
            String parameterName;
            if (field.getValue().isPrimitive()) {
                parameterName = parameter.getName() + "." + field.getKey();
                variableName = parameter.getVariableName();
            } else {
                parameterName = parameter.getName() + "." + field.getKey();
                variableName = parameter.getVariableName() + "." + field.getKey();
            }
            if (load) {
                if (ObjectHelper.isBoolean(field.getValue().getType()) && field.getValue().isPrimitive()) {
                    query.append(variableName).append(" := ( ? = 'A' ) ;\n");
                } else {
                    query.append(variableName).append(" := ? ;\n");
                }
                newParameterList.add(this.createInputParameter(new SqlParameter(parameterName, this.convertToSqlType(field.getValue())), this.getFieldValue(field.getValue().getFieldName(), sourceValue, field.getValue().getType())));
                continue;
            }
            parameterName = "o" + parameterName;
            if (ObjectHelper.isBoolean(field.getValue().getType()) && field.getValue().isPrimitive()) {
                query.append(" if ").append(variableName).append(" then ").append("\n").append("  ob := 'A' ;\n").append(" else").append("\n").append("  ob := 'N' ;\n").append(" end if ;\n").append(" ? := ob ;\n");
            } else {
                query.append(" ? := ").append(variableName).append(" ;\n");
            }
            newParameterList.add((SqlParameter)new SqlOutParameter(parameterName, this.convertToSqlType(field.getValue())));
        }
    }

    private void generateUsingArrayVariables(StringBuilder query, RecordParameter parameter, List<SqlParameter> newParameterList, boolean load) {
        block12: {
            String variableName;
            block11: {
                List sourceList;
                List list = sourceList = load ? (List)this.inputs.get(parameter.getVariableName()) : null;
                if (!load) break block11;
                if (sourceList == null) break block12;
                for (int i = 0; i < sourceList.size(); ++i) {
                    for (Map.Entry<String, FieldInfo> field : this.getFieldEntrySets(parameter.getTargetEntity())) {
                        String variableName2;
                        String parameterName;
                        if (field.getValue().isPrimitive()) {
                            parameterName = parameter.getName() + "(" + i + ")." + field.getKey();
                            variableName2 = parameter.getVariableName() + "(" + i + ")";
                        } else {
                            parameterName = parameter.getName() + "(" + i + ")." + field.getKey();
                            variableName2 = parameter.getVariableName() + "(" + i + ")." + field.getKey();
                        }
                        if (ObjectHelper.isBoolean(field.getValue().getType()) && field.getValue().isPrimitive()) {
                            query.append(variableName2).append(" := ( ? = 'A' ) ;\n");
                        } else {
                            query.append(variableName2).append(" := ? ;\n");
                        }
                        newParameterList.add(this.createInputParameter(new SqlParameter(parameterName, this.convertToSqlType(field.getValue())), this.getFieldValue(field.getValue().getFieldName(), sourceList.get(i), field.getValue().getType())));
                    }
                }
                break block12;
            }
            String parameterName = parameter.getName() + "_COUNT";
            query.append(" ? := ").append(parameter.getVariableName()).append(".count ;\n");
            newParameterList.add((SqlParameter)new SqlOutParameter(parameterName, 2));
            query.append("if ").append(parameter.getVariableName()).append(".count > 0 then \n");
            query.append("for i in  ").append(parameter.getVariableName()).append(".first .. ").append(parameter.getVariableName()).append(".last \n");
            query.append("loop\n");
            query.append("if ").append(parameter.getVariableName()).append(".exists( i ) then \n");
            for (Map.Entry<String, FieldInfo> field : this.getFieldEntrySets(parameter.getTargetEntity())) {
                variableName = this.compressName(parameter.getVariableName() + "_" + field.getKey());
                query.append(variableName).append(".extend( 1 ) ;\n");
                query.append(variableName).append("( ").append(variableName).append(".count ) := ").append(parameter.getVariableName()).append("( i )");
                if (!field.getValue().isPrimitive()) {
                    query.append(".").append(field.getKey());
                }
                query.append(" ;\n");
            }
            query.append("end if ;\n");
            query.append("end loop ;\n");
            query.append("end if ;\n");
            for (Map.Entry<String, FieldInfo> field : this.getFieldEntrySets(parameter.getTargetEntity())) {
                parameterName = this.compressName("o" + parameter.getVariableName() + "_" + field.getKey());
                variableName = this.compressName(parameter.getVariableName() + "_" + field.getKey());
                query.append(" ? := ").append(variableName).append("; \n ");
                if (ObjectHelper.isNumeric(field.getValue())) {
                    newParameterList.add((SqlParameter)new SqlOutParameter(parameterName, 2003, this.getDatabaseSchema() + ".NUMBER_TABLE"));
                    continue;
                }
                if (ObjectHelper.isDate(field.getValue())) {
                    newParameterList.add((SqlParameter)new SqlOutParameter(parameterName, 2003, this.getDatabaseSchema() + ".DATE_TABLE"));
                    continue;
                }
                newParameterList.add((SqlParameter)new SqlOutParameter(parameterName, 2003, this.getDatabaseSchema() + ".VARCHAR_TABLE"));
            }
        }
    }

    private <T> T getFieldValue(String fieldName, Object sourceValue, Class<T> returnType) {
        if (sourceValue == null) {
            return null;
        }
        if (StringHelper.isEqualsIgnoreCase((String)fieldName, (String)"b") || StringHelper.isEqualsIgnoreCase((String)fieldName, (String)"d") || StringHelper.isEqualsIgnoreCase((String)fieldName, (String)"s") || StringHelper.isEqualsIgnoreCase((String)fieldName, (String)"n")) {
            return ObjectHelper.extractFromObject(sourceValue, returnType);
        }
        return ObjectHelper.getValue(fieldName, sourceValue, returnType);
    }

    private int convertToSqlType(FieldInfo fieldInfo) {
        if (ObjectHelper.isNumeric(fieldInfo)) {
            return 2;
        }
        if (ObjectHelper.isDate(fieldInfo)) {
            return 93;
        }
        return 12;
    }

    @Override
    @Deprecated
    public <T> List<T> extractTable(StoredProcedureResult resultMap, String name, Class<T> returnType) {
        return resultMap.extractTable(name, returnType);
    }

    @Override
    @Deprecated
    public <T> void extractTable(StoredProcedureResult resultMap, String name, Class<T> returnType, List<T> target, MergeType mergeType) {
        resultMap.extractTable(name, returnType, target, mergeType);
    }

    @Override
    @Deprecated
    public <T> T extractRecord(StoredProcedureResult resultMap, String name, Class<T> returnType) {
        return resultMap.extractRecord(name, returnType);
    }

    @Override
    @Deprecated
    public <T> boolean extractRecord(StoredProcedureResult resultMap, String name, T returnValue) {
        return resultMap.extractRecord(name, returnValue);
    }

    @Override
    @Deprecated
    public <T> T extract(StoredProcedureResult resultMap, String name, Class<T> returnType) {
        return resultMap.extract(name, returnType);
    }

    @Override
    @Deprecated
    public <T extends StructConvertable> T extractStruct(StoredProcedureResult resultMap, String name, Class<T> returnType) {
        return resultMap.extractStruct(name, returnType);
    }

    @Override
    @Deprecated
    public <T> List<T> extractArray(StoredProcedureResult resultMap, String name, Class<T> returnType) {
        return resultMap.extractArray(name, returnType);
    }

    @Override
    @Deprecated
    public Boolean extractBoolean(StoredProcedureResult resultMap, String name) {
        return resultMap.extractBoolean(name);
    }

    @Override
    @Deprecated
    public <T extends StructConvertable> T extractResultStruct(StoredProcedureResult resultMap, Class<T> returnType) {
        return resultMap.extractResultStruct(returnType);
    }

    @Override
    public <T> T extractResultRecord(StoredProcedureResult resultMap, Class<T> returnType) {
        return resultMap.extractResultRecord(returnType);
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @Override
    public StoredProcedureResult executeIndex() {
        return this.execute(false);
    }

    @Override
    public StoredProcedureResult executeName() {
        return this.execute(true);
    }

    private StoredProcedureResult execute(boolean named) {
        String originalSql = this.getSql();
        if (this.wrapNeed || named) {
            this.generateWrappedQuery(named);
        }
        if (this.entityManager != null && this.entityManager.getDelegate() != null) {
            ((Session)this.entityManager.getDelegate()).flush();
        }
        long startTime = System.currentTimeMillis();
        try {
            StoredProcedureResult storedProcedureResult = new StoredProcedureResult(this.execute(this.inputs), this.long2shortName);
            return storedProcedureResult;
        }
        catch (DataAccessException e) {
            SQLException sqlException;
            if (e.getCause() instanceof SQLException && (sqlException = (SQLException)e.getCause()).getErrorCode() == 4068) {
                StoredProcedureResult storedProcedureResult = new StoredProcedureResult(this.execute(this.inputs), this.long2shortName);
                return storedProcedureResult;
            }
            throw e;
        }
        finally {
            if (PLSQL_LOGGER.isTraceEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                String procedure = originalSql;
                String sql = this.getSql();
                StringBuilder params = new StringBuilder();
                for (SqlParameter sqlParameter : this.getDeclaredParameters()) {
                    if (!sqlParameter.isInputValueProvided()) continue;
                    params.append(sqlParameter.getName());
                    params.append('=');
                    if (this.inputs.containsKey(sqlParameter.getName())) {
                        params.append(this.inputs.get(sqlParameter.getName()));
                    }
                    params.append(';');
                }
                String callstack = ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
                PLSQL_LOGGER.trace("EXEC PLSQL;" + duration + ";\"" + procedure + "\";\"" + sql + "\";\"" + params + "\";\"" + callstack + "\"");
            }
        }
    }
}

