/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.dao.plsql.impl;

import cz.datalite.dao.plsql.SqlLobValueFactory;
import cz.datalite.dao.plsql.StoredProcedureInvoker;
import cz.datalite.dao.plsql.StoredProcedureInvokerCreator;
import cz.datalite.dao.plsql.impl.DefaultStoredProcedureInvoker;
import cz.datalite.stereotype.Autowired;
import cz.datalite.stereotype.DAO;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.nativejdbc.CommonsDbcpNativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

@DAO
class StoreProcedureInvokerCreatorImpl
implements StoredProcedureInvokerCreator {
    @Autowired
    protected SqlLobValueFactory sqlLobValueFactory;
    @Autowired
    protected TransactionAwareDataSourceProxy dataSource;
    @Autowired
    protected NativeJdbcExtractor nativeJdbcExtractor;
    protected EntityManager entityManager;
    @Autowired
    protected PlatformTransactionManager transactionManager;
    private Integer timeout;
    private String databaseSchema = "NXT";

    StoreProcedureInvokerCreatorImpl() {
    }

    @Override
    public Integer getTimeout() {
        if (this.timeout == null) {
            this.timeout = this.transactionManager instanceof AbstractPlatformTransactionManager ? Integer.valueOf(((AbstractPlatformTransactionManager)this.transactionManager).getDefaultTimeout()) : Integer.valueOf(60);
        }
        return this.timeout;
    }

    @Override
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    protected NativeJdbcExtractor getNativeJdbcExtractor() {
        if (this.nativeJdbcExtractor == null) {
            this.nativeJdbcExtractor = new CommonsDbcpNativeJdbcExtractor();
        }
        return this.nativeJdbcExtractor;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public StoredProcedureInvoker create() {
        return this.create((DataSource)this.dataSource);
    }

    @Override
    public StoredProcedureInvoker create(String name) {
        return this.create((DataSource)this.dataSource, name);
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    @Override
    public StoredProcedureInvoker create(String name, int resultType) {
        return this.setupQueryTimeout(new DefaultStoredProcedureInvoker((DataSource)this.dataSource, name, resultType, this.sqlLobValueFactory, this.getDatabaseSchema(), this.entityManager, this.getNativeJdbcExtractor()));
    }

    private StoredProcedureInvoker setupQueryTimeout(DefaultStoredProcedureInvoker invoker) {
        invoker.setQueryTimeout(this.getTimeout());
        return invoker;
    }

    @Override
    public StoredProcedureInvoker create(DataSource dataSource) {
        return this.setupQueryTimeout(new DefaultStoredProcedureInvoker(dataSource, this.sqlLobValueFactory, this.getDatabaseSchema(), this.entityManager, this.getNativeJdbcExtractor()));
    }

    @Override
    public StoredProcedureInvoker create(DataSource dataSource, String name) {
        return this.setupQueryTimeout(new DefaultStoredProcedureInvoker(dataSource, name, this.sqlLobValueFactory, this.getDatabaseSchema(), this.entityManager, this.getNativeJdbcExtractor()));
    }

    @Override
    public StoredProcedureInvoker create(DataSource dataSource, String name, int resultType) {
        return this.setupQueryTimeout(new DefaultStoredProcedureInvoker(dataSource, name, resultType, this.sqlLobValueFactory, this.getDatabaseSchema(), this.entityManager, this.getNativeJdbcExtractor()));
    }
}

