/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.service;

import cz.datalite.dao.GenericDAO;
import cz.datalite.dao.impl.GenericDAOFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GenericAutowiredCandidateResolver
extends SimpleAutowireCandidateResolver
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    ApplicationContext context;
    ListableBeanFactory beanFactory;

    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        if (GenericDAO.class.equals((Object)descriptor.getDependencyType())) {
            Class entityClass = this.resolveEnityClass(descriptor);
            Map candidates = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, GenericDAO.class);
            for (GenericDAO candidate : candidates.values()) {
                if (!this.isGenericDAOOfType(candidate, entityClass)) continue;
                return candidate;
            }
            return this.createDAO(descriptor);
        }
        return super.getSuggestedValue(descriptor);
    }

    protected GenericDAO createDAO(DependencyDescriptor descriptor) {
        Class entityClass = this.resolveEnityClass(descriptor);
        Class idClass = this.resolveTypeParameter(descriptor, 1);
        return GenericDAOFactory.createDAO(this.context, entityClass, idClass, GenericDAO.class);
    }

    private Class resolveEnityClass(DependencyDescriptor descriptor) {
        return this.resolveTypeParameter(descriptor, 0);
    }

    private Class resolveTypeParameter(DependencyDescriptor descriptor, int parameter) {
        if (descriptor.getField() != null) {
            return (Class)((ParameterizedType)descriptor.getField().getGenericType()).getActualTypeArguments()[parameter];
        }
        return (Class)((ParameterizedType)descriptor.getMethodParameter().getGenericParameterType()).getActualTypeArguments()[parameter];
    }

    protected boolean isGenericDAOOfType(GenericDAO dao, Type type) {
        return dao.getPersistentClass().equals(type);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.beanFactory = (ListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory bf = (DefaultListableBeanFactory)beanFactory;
        bf.setAutowireCandidateResolver((AutowireCandidateResolver)this);
    }
}

