/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.service.impl;

import cz.datalite.helpers.EqualsHelper;
import cz.datalite.helpers.StringHelper;
import cz.datalite.model.DataSourceDescriptor;
import cz.datalite.service.DataSourceSwitcherService;
import cz.datalite.service.SwitchDataSourceAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractDataSourceSwitcherService
extends AbstractRoutingDataSource
implements DataSourceSwitcherService,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSourceSwitcherService.class);
    private UserDetailsService userDetailService;
    private String userDetailsServiceName;
    ApplicationContext applicationContext;
    private Map<String, Object> dataSources;
    private List<DataSourceDescriptor> dataSourceDescriptors = new LinkedList<DataSourceDescriptor>();
    private final ThreadLocal<String> dataSourceName = new ThreadLocal();
    private EntityManagerFactory entityManagerFactory;
    boolean awareUserName = true;

    public AbstractDataSourceSwitcherService(String userDetailsServiceName) {
        this.userDetailsServiceName = userDetailsServiceName;
    }

    public AbstractDataSourceSwitcherService(UserDetailsService userDetailsService) {
        this.userDetailService = userDetailsService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        this.dataSources = new LinkedHashMap<String, Object>();
        if (targetDataSources != null) {
            for (Map.Entry<Object, Object> o : targetDataSources.entrySet()) {
                this.dataSources.put((String)o.getKey(), o.getValue());
            }
        }
    }

    public void setDataSourceDescriptors(Map<String, String> dataSourceDescriptors) {
        this.dataSourceDescriptors = new LinkedList<DataSourceDescriptor>();
        for (Map.Entry<String, String> entry : dataSourceDescriptors.entrySet()) {
            this.dataSourceDescriptors.add(new DataSourceDescriptor(entry.getKey(), entry.getValue()));
        }
    }

    protected Object determineCurrentLookupKey() {
        return this.dataSourceName.get();
    }

    @Override
    public boolean isAvailable(String name) {
        return this.dataSources != null && this.dataSources.containsKey(name);
    }

    protected UserDetailsService getUserDetailService() {
        if (this.userDetailService == null && this.applicationContext != null && !StringHelper.isNull((String)this.userDetailsServiceName)) {
            try {
                this.userDetailService = (UserDetailsService)this.applicationContext.getBean(this.userDetailsServiceName);
            }
            catch (Exception e) {
                this.userDetailService = null;
            }
        }
        return this.userDetailService;
    }

    private EntityManagerFactory getEntityManagerFactory() {
        if (this.applicationContext != null && this.entityManagerFactory == null) {
            this.entityManagerFactory = (EntityManagerFactory)this.applicationContext.getBean(EntityManagerFactory.class);
        }
        return this.entityManagerFactory;
    }

    private EntityManagerHolder connectSession(String name) {
        if (!EqualsHelper.isEqualsNull((Object)name, (Object)this.dataSourceName.get())) {
            this.dataSourceName.set(name);
            EntityManagerHolder entityManagerHolder = null;
            if (this.getEntityManagerFactory() != null) {
                if (TransactionSynchronizationManager.hasResource((Object)this.getEntityManagerFactory())) {
                    entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.getEntityManagerFactory());
                    TransactionSynchronizationManager.unbindResource((Object)this.getEntityManagerFactory());
                }
                EntityManager entityManager = this.getEntityManagerFactory().createEntityManager();
                TransactionSynchronizationManager.bindResource((Object)this.getEntityManagerFactory(), (Object)new EntityManagerHolder(entityManager));
                LOGGER.info("Switch hibernate session to " + (this.dataSourceName.get() == null ? "default" : this.dataSourceName.get()));
            }
            return entityManagerHolder;
        }
        return null;
    }

    private void disconnectSession(EntityManagerHolder entityManagerHolder) {
        if (this.getEntityManagerFactory() != null) {
            if (TransactionSynchronizationManager.hasResource((Object)this.getEntityManagerFactory())) {
                Session hibernateSession;
                EntityManagerHolder current = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.getEntityManagerFactory());
                TransactionSynchronizationManager.unbindResource((Object)this.getEntityManagerFactory());
                if (current != null && current != entityManagerHolder && (hibernateSession = (Session)current.getEntityManager().getDelegate()).isConnected() && hibernateSession.isOpen()) {
                    LOGGER.debug("Switch hibernate session from " + (this.dataSourceName.get() == null ? "default" : this.dataSourceName.get()));
                    hibernateSession.disconnect();
                    current.getEntityManager().close();
                }
            }
            this.dataSourceName.remove();
            if (entityManagerHolder != null) {
                TransactionSynchronizationManager.bindResource((Object)this.getEntityManagerFactory(), (Object)entityManagerHolder);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.getConnection(this.dataSourceName.get());
        this.afterGetConnection(connection);
        return connection;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.getConnection(this.dataSourceName.get(), username, password);
        this.afterGetConnection(connection);
        return connection;
    }

    protected void afterGetConnection(Connection connection) {
    }

    protected DataSource getDataSource(String name) {
        return name == null ? this.determineTargetDataSource() : this.resolveSpecifiedDataSource(this.dataSources.get(name));
    }

    protected Connection getConnection(String database, String username, String password) throws SQLException {
        return this.getDataSource(database).getConnection(username, password);
    }

    protected abstract UserDetails getUserDetails();

    protected Connection getConnection(String database) throws SQLException {
        if (this.getUserDetailService() != null && this.awareUserName) {
            UserDetails userDetails = this.getUserDetails();
            if (database != null) {
                String loginName;
                String string = loginName = userDetails != null ? userDetails.getUsername() : null;
                if (loginName != null) {
                    this.awareUserName = false;
                    userDetails = this.getUserDetailService().loadUserByUsername(loginName);
                    LOGGER.debug("Refresh user details: " + userDetails.getUsername());
                    this.awareUserName = true;
                }
            }
            if (userDetails != null) {
                try {
                    Connection connection = this.getDataSource(database).getConnection(userDetails.getUsername(), userDetails.getPassword());
                    LOGGER.debug("Get connection " + (database == null ? "" : database) + " for " + userDetails.getUsername() + ": " + connection.getMetaData().getURL());
                    return connection;
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.debug("User aware to connection is unsupperted. Use standard connection");
                }
            }
        }
        Connection connection = this.getDataSource(database).getConnection();
        LOGGER.debug("Get default connection " + (database == null ? "" : database) + ": " + connection.getMetaData().getURL());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(String database, SwitchDataSourceAction<T> action) {
        String oldDatabase = this.dataSourceName.get();
        EntityManagerHolder previous = null;
        try {
            previous = this.connectSession(database);
            T t = action.execute();
            return t;
        }
        finally {
            this.disconnectSession(previous);
        }
    }

    @Override
    public List<DataSourceDescriptor> getDataSources(boolean removeCurrent) {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>(this.dataSourceDescriptors);
        if (removeCurrent) {
            result.remove(this.getCurrentDataSource());
        }
        return result;
    }

    @Override
    public List<DataSourceDescriptor> getDataSources() {
        return this.getDataSources(false);
    }

    private String getCurrentDataSourceName() {
        String oldDatabase = this.dataSourceName.get();
        if (StringHelper.isNull((String)oldDatabase)) {
            oldDatabase = this.getCurrentDataSourceNameFromUserDetails();
        }
        return oldDatabase;
    }

    protected abstract String getCurrentDataSourceNameFromUserDetails();

    @Override
    public DataSourceDescriptor getCurrentDataSource() {
        String oldDatabase = this.getCurrentDataSourceName();
        for (DataSourceDescriptor dsd : this.dataSourceDescriptors) {
            if (!StringHelper.isEquals((String)dsd.getName(), (String)oldDatabase)) continue;
            return dsd;
        }
        return null;
    }
}

