/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.service.impl;

import cz.datalite.service.ConnectionInterceptor;
import cz.datalite.service.InterceptorDataSourceSwitcherService;
import cz.datalite.service.impl.AbstractDataSourceSwitcherService;
import java.sql.Connection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.springframework.security.core.userdetails.UserDetailsService;

public abstract class AbstractInterceptorDataSourceSwitcherService
extends AbstractDataSourceSwitcherService
implements InterceptorDataSourceSwitcherService {
    private List<Class<? extends ConnectionInterceptor>> connectionInterceptorClasses = new LinkedList<Class<? extends ConnectionInterceptor>>();
    private List<ConnectionInterceptor> connectionInterceptors = new LinkedList<ConnectionInterceptor>();
    private boolean enabled = true;
    private Set<Class<? extends ConnectionInterceptor>> disabled = new HashSet<Class<? extends ConnectionInterceptor>>();

    public AbstractInterceptorDataSourceSwitcherService(String userDetailsServiceName) {
        super(userDetailsServiceName);
    }

    public AbstractInterceptorDataSourceSwitcherService(UserDetailsService userDetailsService) {
        super(userDetailsService);
    }

    @Override
    public void setConnectionInterceptorClasses(List<Class<? extends ConnectionInterceptor>> connectionInterceptorClasses) {
        if (connectionInterceptorClasses != null) {
            this.connectionInterceptorClasses.clear();
            this.connectionInterceptorClasses.addAll(connectionInterceptorClasses);
        }
    }

    @Override
    public void setConnectionInterceptors(List<ConnectionInterceptor> connectionInterceptors) {
        if (connectionInterceptors != null) {
            this.connectionInterceptors.clear();
            this.connectionInterceptors.addAll(connectionInterceptors);
        }
    }

    @Override
    protected void afterGetConnection(Connection connection) {
        if (!this.isEnableInterceptors(connection)) {
            return;
        }
        for (ConnectionInterceptor ci : this.connectionInterceptors) {
            if (this.disabled.contains(ci.getClass())) continue;
            ci.onConnection(connection);
        }
        if (this.applicationContext != null) {
            ListIterator<Class<? extends ConnectionInterceptor>> it = this.connectionInterceptorClasses.listIterator();
            while (it.hasNext()) {
                Class<? extends ConnectionInterceptor> next = it.next();
                if (next == null || this.disabled.contains(next)) continue;
                ConnectionInterceptor ci = (ConnectionInterceptor)this.applicationContext.getBean(next);
                this.connectionInterceptors.add(ci);
                it.remove();
                ci.onConnection(connection);
            }
        }
    }

    protected boolean isEnableInterceptors(Connection connection) {
        return this.enabled;
    }

    @Override
    public void disableInterceptors() {
        this.enabled = false;
    }

    @Override
    public void enableInterceptors() {
        this.enabled = true;
    }

    @Override
    public <Type extends ConnectionInterceptor> void disableInterceptor(Class<Type> type) {
        this.disabled.add(type);
    }

    @Override
    public <Type extends ConnectionInterceptor> void enableInterceptors(Class<Type> type) {
        this.disabled.remove(type);
    }
}

