/*
 * Decompiled with CFR 0.152.
 */
package cz.datalite.service.impl;

import cz.datalite.dao.DLResponse;
import cz.datalite.dao.DLSearch;
import cz.datalite.dao.GenericDAO;
import cz.datalite.dao.impl.GenericDAOFactory;
import cz.datalite.helpers.ReflectionHelper;
import cz.datalite.service.GenericService;
import cz.datalite.stereotype.Autowired;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class GenericServiceImpl<T, ID extends Serializable, DAO extends GenericDAO<T, ID>>
implements GenericService<T, ID> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GenericServiceImpl.class);
    protected DAO defaultDAO;
    private Class<T> entityClass;
    private Class<ID> idClass;
    private Class<DAO> daoClass;

    public GenericServiceImpl() {
        List types = ReflectionHelper.getTypeArguments(GenericServiceImpl.class, this.getClass());
        if (types.size() != 3) {
            throw new InstantiationError("Invalid number type parameters of '" + this.getClass().getName() + "'. All three parameters - entity type, primary key type and DAO class are mandatory.");
        }
        this.entityClass = (Class)types.get(0);
        this.idClass = (Class)types.get(1);
        this.daoClass = (Class)types.get(2);
        LOGGER.trace("Create new Service for class '{}' EntityClass = '{}', DAOClass = '{}'.", new Object[]{this.getClass().getCanonicalName(), this.entityClass.getCanonicalName(), this.daoClass.getCanonicalName()});
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansOfType(this.daoClass);
        if (beans.isEmpty() || GenericDAO.class.getName().equals(this.daoClass.getName())) {
            this.defaultDAO = GenericDAOFactory.createDAO(applicationContext, this.entityClass, this.idClass, this.daoClass);
            LOGGER.trace("Default DAO created - '{}'.", (Object)this.defaultDAO.getClass().getCanonicalName());
        } else {
            if (beans.size() > 1) {
                StringBuffer keys = new StringBuffer();
                for (String bean : beans.keySet()) {
                    keys.append(bean);
                    keys.append(",");
                }
                throw new InstantiationError("Error autowiring bean '" + this.getClass().getName() + "': Multiple bean exists of DAO type " + this.daoClass.getName() + "' [" + keys.toString() + "]");
            }
            this.defaultDAO = (GenericDAO)applicationContext.getBeansOfType(this.daoClass).values().iterator().next();
            LOGGER.trace("Uniqueue default DAO got by bean class type '{}'.", (Object)this.daoClass.getCanonicalName());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public T get(ID id) {
        return (T)this.defaultDAO.get(id);
    }

    @Override
    @Transactional(readOnly=true)
    public T get(ID id, String ... path) {
        return (T)this.defaultDAO.get(id, path);
    }

    @Override
    @Transactional(readOnly=true)
    public T get(T entity) {
        if (entity == null) {
            return null;
        }
        return (T)this.defaultDAO.get(entity);
    }

    @Override
    @Transactional(readOnly=true)
    public T get(T entity, String ... associationPath) {
        if (entity == null) {
            return null;
        }
        return (T)this.defaultDAO.get(entity, associationPath);
    }

    @Override
    @Transactional(readOnly=true)
    public T findById(ID id, boolean lock) {
        return (T)this.defaultDAO.findById(id, lock);
    }

    @Override
    @Transactional(readOnly=true)
    public T findById(ID id) {
        return (T)this.defaultDAO.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findAll() {
        return this.defaultDAO.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByExample(T exampleInstance) {
        return this.defaultDAO.findByExample(exampleInstance);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByExample(T exampleInstance, String[] excludeProperty) {
        return this.defaultDAO.findByExample(exampleInstance, excludeProperty);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> search(DLSearch<T> search) {
        return this.defaultDAO.search(search);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer count(DLSearch<T> search) {
        return this.defaultDAO.count(search);
    }

    @Override
    @Transactional(readOnly=true)
    public DLResponse<T> searchAndCount(DLSearch<T> search) {
        return this.defaultDAO.searchAndCount(search);
    }

    @Override
    @Transactional
    public void save(T entity) {
        this.defaultDAO.makePersistent(entity);
    }

    @Override
    @Transactional
    public void delete(T entity) {
        this.defaultDAO.makeTransient(entity);
    }

    @Override
    @Transactional(readOnly=true)
    public T attachPersistenceContext(T entity) {
        return (T)this.defaultDAO.reattach(entity);
    }
}

