package cz.datalite.zk.components.profile.impl;

import cz.datalite.zk.components.profile.DLListboxProfileCategory;

import java.util.Comparator;

/**
 * Listbox profile category - simple javabean implementation.
 */
public class DLListboxProfileCategoryImpl implements DLListboxProfileCategory {

    /** profile category id - usually generated by persistent storage */
    private Long profileCategoryId;

    /** profile category name */
    private String profileCategoryName;

    /** profile category description */
    private String profileCategoryDescription;

    public Long getProfileCategoryId() {
        return profileCategoryId;
    }

    public void setProfileCategoryId(Long profileCategoryId) {
        this.profileCategoryId = profileCategoryId;
    }

    public String getProfileCategoryName() {
        return profileCategoryName;
    }

    public void setProfileCategoryName(String profileCategoryName) {
        this.profileCategoryName = profileCategoryName;
    }

    public String getProfileCategoryDescription() {
        return profileCategoryDescription;
    }

    public void setProfileCategoryDescription(String profileCategoryDescription) {
        this.profileCategoryDescription = profileCategoryDescription;
    }

    public static class NameComparator implements Comparator<DLListboxProfileCategory> {
        @Override
        public int compare(DLListboxProfileCategory p1, DLListboxProfileCategory p2) {
            if (p1.getProfileCategoryName() != null && p2.getProfileCategoryName() != null) {
                return p1.getProfileCategoryName().compareTo(p2.getProfileCategoryName());
            } else {
                return 0;
            }
        }
    }
}
