/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.impl.apacheclient;

import cz.gopay.api.v3.PaymentClient;
import cz.gopay.api.v3.impl.apacheclient.AbstractImpl;
import cz.gopay.api.v3.impl.apacheclient.HttpClientAuthClientImpl;
import cz.gopay.api.v3.model.access.AuthHeader;
import cz.gopay.api.v3.model.payment.BasePayment;
import cz.gopay.api.v3.model.payment.NextPayment;
import cz.gopay.api.v3.model.payment.Payment;
import cz.gopay.api.v3.model.payment.PaymentResult;
import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.log4j.Logger;

public class HttpClientPaymentclientImpl
extends AbstractImpl
implements PaymentClient {
    protected HttpClientPaymentclientImpl(String apiUrl) {
        super(apiUrl);
        this.logger = Logger.getLogger(HttpClientAuthClientImpl.class);
    }

    public Payment createPayment(AuthHeader authHeader, BasePayment createPayment) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).bodyString(this.marshall(createPayment), ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, Payment.class);
    }

    public PaymentResult refundPayment(AuthHeader authHeader, Long id, Long amount) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/refund")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).bodyString("amount=" + amount, ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public Payment createRecurrentPayment(AuthHeader authHeader, Long id, NextPayment createPayment) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/create-recurrence")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).bodyString(this.marshall(createPayment), ContentType.TEXT_XML).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, Payment.class);
    }

    public PaymentResult voidRecurrence(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/void-recurrence")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).execute();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public PaymentResult capturePayment(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/capture")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public PaymentResult voidAuthorization(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/void-authorization")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public Payment getPayment(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Get((String)(this.apiUrl + "/payments/payment/" + id)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, Payment.class);
    }
}

