/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.UrlUtil;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractGenerator<I extends AbstractGenerator> {
    protected Map<String, WebPage> urls = new TreeMap<String, WebPage>();
    protected String baseUrl;

    public AbstractGenerator(String baseUrl, boolean root) {
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new InvalidUrlException(e);
        }
        if (root && !baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
    }

    public AbstractGenerator(String baseUrl) {
        this(baseUrl, true);
    }

    public I addPage(WebPage webPage) {
        this.beforeAddPageEvent(webPage);
        this.urls.put(UrlUtil.connectUrlParts(this.baseUrl, webPage.constructName()), webPage);
        return this.getThis();
    }

    public I addPage(String name) {
        return this.addPage(WebPage.of(name));
    }

    public I addPage(StringSupplierWithException<String> supplier) {
        try {
            this.addPage(supplier.get());
        }
        catch (Exception e) {
            AbstractGenerator.sneakyThrow(e);
        }
        return this.getThis();
    }

    protected void beforeAddPageEvent(WebPage webPage) {
    }

    public I addPages(Collection<WebPage> webPages) {
        for (WebPage webPage : webPages) {
            this.addPage(webPage);
        }
        return this.getThis();
    }

    public I addPages(Supplier<Collection<WebPage>> webPagesSupplier) {
        for (WebPage webPage : webPagesSupplier.get()) {
            this.addPage(webPage);
        }
        return this.getThis();
    }

    public <T> I addPages(Collection<T> webPages, Function<T, WebPage> mapper) {
        for (T element : webPages) {
            this.addPage(mapper.apply(element));
        }
        return this.getThis();
    }

    public <T> I addPageNames(Collection<T> webPages, Function<T, String> mapper) {
        for (T element : webPages) {
            this.addPage(WebPage.of(mapper.apply(element)));
        }
        return this.getThis();
    }

    public <T> I addPages(Supplier<Collection<T>> webPagesSupplier, Function<T, WebPage> mapper) {
        for (T element : webPagesSupplier.get()) {
            this.addPage(mapper.apply(element));
        }
        return this.getThis();
    }

    public <T> I addPageNames(Supplier<Collection<T>> webPagesSupplier, Function<T, String> mapper) {
        for (T element : webPagesSupplier.get()) {
            this.addPage(WebPage.of(mapper.apply(element)));
        }
        return this.getThis();
    }

    public I run(RunnableWithException runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            AbstractGenerator.sneakyThrow(e);
        }
        return this.getThis();
    }

    public I run(GeneratorConsumerWithException<I> consumer) {
        try {
            consumer.accept(this.getThis());
        }
        catch (Exception e) {
            AbstractGenerator.sneakyThrow(e);
        }
        return this.getThis();
    }

    protected I getThis() {
        return (I)this;
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    protected String toPrettyXmlString(String xml, int indent) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface StringSupplierWithException<S> {
        public S get() throws Exception;
    }

    public static interface GeneratorConsumerWithException<T> {
        public void accept(T var1) throws Exception;
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

