/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.AbstractGenerator;
import cz.jiripinkas.jsitemapgenerator.ChangeFreq;
import cz.jiripinkas.jsitemapgenerator.HttpClient;
import cz.jiripinkas.jsitemapgenerator.Ping;
import cz.jiripinkas.jsitemapgenerator.PingResponse;
import cz.jiripinkas.jsitemapgenerator.UrlUtil;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidPriorityException;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import cz.jiripinkas.jsitemapgenerator.exception.WebmasterToolsException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractSitemapGenerator<T extends AbstractGenerator>
extends AbstractGenerator<T> {
    protected W3CDateFormat dateFormat = new W3CDateFormat();
    private ChangeFreq defaultChangeFreq;
    private Double defaultPriority;
    private String defaultDir;
    private String defaultExtension;
    private Date defaultLastMod;
    private HttpClient httpClient = new HttpClient();

    public AbstractSitemapGenerator(String baseUrl) {
        super(baseUrl);
    }

    public abstract String[] toStringArray();

    public String toString() {
        String[] sitemapArray = this.toStringArray();
        StringBuilder result = new StringBuilder();
        for (String line : sitemapArray) {
            result.append(line);
        }
        return result.toString();
    }

    public T toString(Consumer<String> stringConsumer) {
        stringConsumer.accept(this.toString());
        return (T)this.getThis();
    }

    public String toPrettyString(int indent) {
        return this.toPrettyXmlString(this.toString(), indent).replace("\r\n", "\n");
    }

    public T toPrettyString(int indent, Consumer<String> stringConsumer) {
        stringConsumer.accept(this.toPrettyString(indent));
        return (T)this.getThis();
    }

    private ByteArrayOutputStream gzipIt(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (GZIPOutputStream gzos = new GZIPOutputStream(outputStream);
             InputStream in = inputStream;){
            int len;
            while ((len = in.read(buffer)) > 0) {
                gzos.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot perform gzip", ex);
        }
        return outputStream;
    }

    public byte[] toGzipByteArray() {
        String sitemap = this.toString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sitemap.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream outputStream = this.gzipIt(inputStream);
        return outputStream.toByteArray();
    }

    public T toGzipByteArray(Consumer<byte[]> byteArrayConsumer) {
        byteArrayConsumer.accept(this.toGzipByteArray());
        return (T)this.getThis();
    }

    public T toFile(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        String[] sitemap = this.toStringArray();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String string : sitemap) {
                writer.write(string);
            }
        }
        return (T)this.getThis();
    }

    public T toFile(Supplier<File> fileSupplier) throws IOException {
        return this.toFile(fileSupplier.get());
    }

    public T toFile(Path path) throws IOException {
        return this.toFile(path.toFile());
    }

    public T toFile(String first, String ... more) throws IOException {
        return this.toFile(Paths.get(first, more));
    }

    public T toFile(File parent, String child) throws IOException {
        return this.toFile(new File(parent, child));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public PingResponse ping(Ping ping) {
        try {
            for (Ping.SearchEngine searchEngine : ping.getSearchEngines()) {
                if (searchEngine == Ping.SearchEngine.GOOGLE) {
                    resourceUrl = "https://www.google.com/ping?sitemap=";
                } else if (searchEngine == Ping.SearchEngine.BING) {
                    resourceUrl = "https://www.bing.com/ping?sitemap=";
                } else {
                    throw new UnsupportedOperationException("Unknown search engine: " + (Object)searchEngine);
                }
                sitemapUrl = ping.getSitemapUrl() == null ? this.getAbsoluteUrl("sitemap.xml", false) : this.getAbsoluteUrl(ping.getSitemapUrl(), false);
                responseIsNot200 = false;
                if (ping.getHttpClientType() == null) {
                    this.ping(resourceUrl, sitemapUrl, searchEngine.getPrettyName());
                } else if (ping.getHttpClientType() == Ping.HttpClientType.REST_TEMPLATE) {
                    pingUrl = resourceUrl + sitemapUrl;
                    restTemplate = (RestTemplate)ping.getHttpClientImplementation();
                    responseEntity = restTemplate.getForEntity(pingUrl, String.class, new Object[0]);
                    if (responseEntity.getStatusCodeValue() != 200) {
                        responseIsNot200 = true;
                    }
                } else if (ping.getHttpClientType() == Ping.HttpClientType.OK_HTTP) {
                    pingUrl = resourceUrl + URLEncoder.encode(sitemapUrl, "UTF-8");
                    okHttpClient = (OkHttpClient)ping.getHttpClientImplementation();
                    request = new Request.Builder().url(pingUrl).build();
                    response = okHttpClient.newCall(request).execute();
                    try {
                        if (response.isSuccessful()) ** GOTO lbl58
                        responseIsNot200 = true;
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                } else if (ping.getHttpClientType() == Ping.HttpClientType.APACHE_HTTP_CLIENT) {
                    pingUrl = resourceUrl + URLEncoder.encode(sitemapUrl, "UTF-8");
                    httpGet = Class.forName("org.apache.http.client.methods.HttpGet").getDeclaredConstructor(new Class[]{String.class}).newInstance(new Object[]{pingUrl});
                    execute = Class.forName("org.apache.http.impl.client.CloseableHttpClient").getMethod("execute", new Class[]{Class.forName("org.apache.http.client.methods.HttpUriRequest")});
                    httpResponse = null;
                    try {
                        httpResponse = execute.invoke(ping.getHttpClientImplementation(), new Object[]{httpGet});
                        getEntity = Class.forName("org.apache.http.HttpResponse").getMethod("getEntity", new Class[0]);
                        httpEntity = getEntity.invoke(httpResponse, new Object[0]);
                        consume = Class.forName("org.apache.http.util.EntityUtils").getMethod("consume", new Class[]{Class.forName("org.apache.http.HttpEntity")});
                        consume.invoke(null, new Object[]{httpEntity});
                        getStatusLine = Class.forName("org.apache.http.HttpResponse").getMethod("getStatusLine", new Class[0]).invoke(httpResponse, new Object[0]);
                        getStatusCode = (Integer)Class.forName("org.apache.http.StatusLine").getMethod("getStatusCode", new Class[0]).invoke(getStatusLine, new Object[0]);
                        if (getStatusCode == 200) ** GOTO lbl58
                        responseIsNot200 = true;
                    }
                    finally {
                        if (httpResponse != null) {
                            Class.forName("java.io.Closeable").getMethod("close", new Class[0]).invoke(httpResponse, new Object[0]);
                        }
                    }
                } else {
                    throw new UnsupportedOperationException("Unknown HttpClientType!");
                }
lbl58:
                // 6 sources

                if (!responseIsNot200) continue;
                throw new WebmasterToolsException(searchEngine.getPrettyName() + " could not be informed about new sitemap! Return code != 200");
            }
        }
        catch (Exception e) {
            return new PingResponse(true, new WebmasterToolsException(e));
        }
        return new PingResponse(false);
    }

    @Deprecated
    public void pingGoogle(String sitemapUrl) {
        this.ping("https://www.google.com/ping?sitemap=", sitemapUrl, "Google");
    }

    @Deprecated
    public boolean pingGoogle(String sitemapUrl, boolean doNotThrowExceptionOnFailure) {
        try {
            this.pingGoogle(sitemapUrl);
            return true;
        }
        catch (Exception e) {
            if (doNotThrowExceptionOnFailure) {
                return false;
            }
            throw e;
        }
    }

    @Deprecated
    public void pingBing(String sitemapUrl) {
        this.ping("https://www.bing.com/ping?sitemap=", sitemapUrl, "Bing");
    }

    @Deprecated
    public boolean pingBing(String sitemapUrl, boolean doNotThrowExceptionOnFailure) {
        try {
            this.pingBing(sitemapUrl);
            return true;
        }
        catch (Exception e) {
            if (doNotThrowExceptionOnFailure) {
                return false;
            }
            throw e;
        }
    }

    @Deprecated
    public void pingGoogle() {
        this.pingGoogle(this.baseUrl + "sitemap.xml");
    }

    @Deprecated
    public boolean pingGoogle(boolean doNotThrowExceptionOnFailure) {
        try {
            this.pingGoogle();
            return true;
        }
        catch (Exception e) {
            if (doNotThrowExceptionOnFailure) {
                return false;
            }
            throw e;
        }
    }

    @Deprecated
    public void pingBing() {
        this.pingBing(this.baseUrl + "sitemap.xml");
    }

    @Deprecated
    public boolean pingBing(boolean doNotThrowExceptionOnFailure) {
        try {
            this.pingBing();
            return true;
        }
        catch (Exception e) {
            if (doNotThrowExceptionOnFailure) {
                return false;
            }
            throw e;
        }
    }

    private void ping(String resourceUrl, String sitemapUrl, String serviceName) {
        try {
            String pingUrl = resourceUrl + URLEncoder.encode(sitemapUrl, "UTF-8");
            int returnCode = this.httpClient.get(pingUrl);
            if (returnCode != 200) {
                throw new WebmasterToolsException(serviceName + " could not be informed about new sitemap! Return code != 200");
            }
        }
        catch (Exception ex) {
            throw new WebmasterToolsException(serviceName + " could not be informed about new sitemap!", ex);
        }
    }

    @Override
    protected void beforeAddPageEvent(WebPage webPage) {
        if (this.defaultDir != null && webPage.getDir() == null) {
            webPage.setName(UrlUtil.connectUrlParts(this.defaultDir, webPage.constructName()));
        }
        if (this.defaultExtension != null && webPage.getExtension() == null) {
            webPage.setName(webPage.constructName() + "." + this.defaultExtension);
        }
        if (this.defaultPriority != null && webPage.getPriority() == null) {
            webPage.setPriority(this.defaultPriority);
        }
        if (this.defaultChangeFreq != null && webPage.getChangeFreq() == null) {
            webPage.setChangeFreq(this.defaultChangeFreq);
        }
        if (this.defaultLastMod != null && webPage.getLastMod() == null) {
            webPage.setLastMod(this.defaultLastMod);
        }
    }

    public T defaultDir(String dirName) {
        this.defaultDir = dirName;
        return (T)this.getThis();
    }

    public T defaultDir(String ... dirNames) {
        this.defaultDir = String.join((CharSequence)"/", dirNames);
        return (T)this.getThis();
    }

    public T resetDefaultDir() {
        this.defaultDir = null;
        return (T)this.getThis();
    }

    public T defaultExtension(String extension) {
        this.defaultExtension = extension;
        return (T)this.getThis();
    }

    public T resetDefaultExtension() {
        this.defaultExtension = null;
        return (T)this.getThis();
    }

    public T defaultPriorityMax() {
        this.defaultPriority = 1.0;
        return (T)this.getThis();
    }

    public T defaultPriority(Double priority) {
        if (priority < 0.0 || priority > 1.0) {
            throw new InvalidPriorityException("Priority must be between 0 and 1.0");
        }
        this.defaultPriority = priority;
        return (T)this.getThis();
    }

    public T resetDefaultPriority() {
        this.defaultPriority = null;
        return (T)this.getThis();
    }

    public T defaultChangeFreq(ChangeFreq changeFreq) {
        this.defaultChangeFreq = changeFreq;
        return (T)this.getThis();
    }

    public T defaultChangeFreqAlways() {
        this.defaultChangeFreq = ChangeFreq.ALWAYS;
        return (T)this.getThis();
    }

    public T defaultChangeFreqHourly() {
        this.defaultChangeFreq = ChangeFreq.HOURLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqDaily() {
        this.defaultChangeFreq = ChangeFreq.DAILY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqWeekly() {
        this.defaultChangeFreq = ChangeFreq.WEEKLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqMonthly() {
        this.defaultChangeFreq = ChangeFreq.MONTHLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqYearly() {
        this.defaultChangeFreq = ChangeFreq.YEARLY;
        return (T)this.getThis();
    }

    public T defaultChangeFreqNever() {
        this.defaultChangeFreq = ChangeFreq.NEVER;
        return (T)this.getThis();
    }

    public T resetDefaultChangeFreq() {
        this.defaultChangeFreq = null;
        return (T)this.getThis();
    }

    public T defaultLastMod(Date lastMod) {
        this.defaultLastMod = lastMod;
        return (T)this.getThis();
    }

    public T defaultLastMod(LocalDateTime lastMod) {
        this.defaultLastMod = Timestamp.valueOf(lastMod);
        return (T)this.getThis();
    }

    public T defaultLastModNow() {
        this.defaultLastMod = new Date();
        return (T)this.getThis();
    }

    public T resetDefaultLastMod() {
        this.defaultLastMod = null;
        return (T)this.getThis();
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected String getAbsoluteUrl(String webPageName) {
        return this.getAbsoluteUrl(webPageName, true);
    }

    protected String getAbsoluteUrl(String webPageName, boolean escapeSpecialCharacters) {
        if (escapeSpecialCharacters) {
            webPageName = UrlUtil.escapeXmlSpecialCharacters(webPageName);
        }
        try {
            String resultString;
            if (webPageName != null) {
                URI uri = new URI(webPageName);
                String stringUrl = uri.isAbsolute() ? webPageName : UrlUtil.connectUrlParts(this.baseUrl, webPageName);
                resultString = stringUrl;
            } else {
                resultString = this.baseUrl;
            }
            return new URL(resultString).toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InvalidUrlException(e);
        }
    }
}

