/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Ping {
    private List<SearchEngine> searchEngines;
    private String sitemapUrl;
    private HttpClientType httpClientType;
    private Object httpClientImplementation;

    public Ping(List<SearchEngine> searchEngines, String sitemapUrl, HttpClientType httpClientType, Object httpClientImplementation) {
        this.searchEngines = searchEngines;
        this.sitemapUrl = sitemapUrl;
        this.httpClientType = httpClientType;
        this.httpClientImplementation = httpClientImplementation;
    }

    public List<SearchEngine> getSearchEngines() {
        return this.searchEngines;
    }

    public String getSitemapUrl() {
        return this.sitemapUrl;
    }

    public HttpClientType getHttpClientType() {
        return this.httpClientType;
    }

    public Object getHttpClientImplementation() {
        return this.httpClientImplementation;
    }

    public static PingBuilder builder() {
        return new PingBuilder();
    }

    public static class PingBuilder {
        private List<SearchEngine> searchEngines = new ArrayList<SearchEngine>();
        private String sitemapUrl = "sitemap.xml";
        private HttpClientType httpClientType;
        private Object httpClientImplementation;

        private PingBuilder() {
        }

        public PingBuilder engines(SearchEngine ... searchEngines) {
            this.searchEngines.addAll(Arrays.asList(searchEngines));
            return this;
        }

        public PingBuilder sitemapUrl(String sitemapUrl) {
            this.sitemapUrl = sitemapUrl;
            return this;
        }

        public PingBuilder httpClientDefault() {
            this.httpClientType = null;
            this.httpClientImplementation = null;
            return this;
        }

        public PingBuilder httpClientOkHttp(Object okHttpClient) {
            this.httpClientType = HttpClientType.OK_HTTP;
            this.httpClientImplementation = okHttpClient;
            return this;
        }

        public PingBuilder httpClientRestTemplate(Object restTemplate) {
            this.httpClientType = HttpClientType.REST_TEMPLATE;
            this.httpClientImplementation = restTemplate;
            return this;
        }

        public PingBuilder httpClientApacheHttpClient(Object closeableHttpClient) {
            this.httpClientType = HttpClientType.APACHE_HTTP_CLIENT;
            this.httpClientImplementation = closeableHttpClient;
            return this;
        }

        public Ping build() {
            if (this.searchEngines.isEmpty()) {
                throw new UnsupportedOperationException("Must provide at least one search engine!");
            }
            return new Ping(this.searchEngines, this.sitemapUrl, this.httpClientType, this.httpClientImplementation);
        }
    }

    public static enum HttpClientType {
        OK_HTTP,
        APACHE_HTTP_CLIENT,
        REST_TEMPLATE;

    }

    public static enum SearchEngine {
        GOOGLE("Google", "https://www.google.com/ping?sitemap="),
        BING("Bing", "https://www.bing.com/ping?sitemap=");

        private String prettyName;
        private String pingUrl;

        private SearchEngine(String prettyName, String pingUrl) {
            this.prettyName = prettyName;
            this.pingUrl = pingUrl;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public String getPingUrl() {
            return this.pingUrl;
        }
    }
}

