/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator.generator;

import cz.jiripinkas.jsitemapgenerator.AbstractSitemapGenerator;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import java.util.ArrayList;
import java.util.Collections;

public class SitemapIndexGenerator
extends AbstractSitemapGenerator<SitemapIndexGenerator> {
    public SitemapIndexGenerator(String baseUrl) {
        super(baseUrl);
    }

    public static SitemapIndexGenerator of(String baseUrl) {
        return new SitemapIndexGenerator(baseUrl);
    }

    @Override
    public String[] toStringArray() {
        ArrayList<String> out = new ArrayList<String>();
        out.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.add("<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
        ArrayList values = new ArrayList(this.urls.values());
        Collections.sort(values);
        for (WebPage webPage : values) {
            out.add(this.constructUrl(webPage));
        }
        out.add("</sitemapindex>");
        return out.toArray(new String[0]);
    }

    protected String constructUrl(WebPage webPage) {
        StringBuilder out = new StringBuilder();
        out.append("<sitemap>\n");
        out.append("<loc>");
        out.append(this.getAbsoluteUrl(webPage.constructName()));
        out.append("</loc>\n");
        if (webPage.getLastMod() != null) {
            out.append("<lastmod>");
            out.append(this.dateFormat.format(webPage.getLastMod()));
            out.append("</lastmod>\n");
        }
        out.append("</sitemap>\n");
        return out.toString();
    }
}

