/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.embedmongo;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import cz.jirutka.spring.embedmongo.EmbeddedMongoBuilder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class EmbeddedMongoFactoryBean
implements FactoryBean<Mongo>,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedMongoFactoryBean.class);
    private final EmbeddedMongoBuilder builder = new EmbeddedMongoBuilder();
    private MongoClient mongoClient;

    public MongoClient getObject() throws IOException {
        this.mongoClient = this.builder.build();
        return this.mongoClient;
    }

    public Class<MongoClient> getObjectType() {
        return MongoClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.mongoClient != null) {
            LOG.info("Stopping embedded MongoDB instance");
            this.mongoClient.close();
        }
    }

    public void setVersion(String version) {
        this.builder.version(version);
    }

    public void setPort(int port) {
        this.builder.port(port);
    }

    public void setBindIp(String bindIp) {
        this.builder.bindIp(bindIp);
    }
}

