/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler;

import cz.jirutka.spring.exhandler.RestHandlerExceptionResolver;
import cz.jirutka.spring.exhandler.RestHandlerExceptionResolverBuilder;
import cz.jirutka.spring.exhandler.handlers.RestExceptionHandler;
import cz.jirutka.spring.exhandler.interpolators.MessageInterpolator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.accept.ContentNegotiationManager;

public class RestHandlerExceptionResolverFactoryBean
implements FactoryBean<RestHandlerExceptionResolver> {
    private ContentNegotiationManager contentNegotiationManager;
    private String defaultContentType;
    private Map<Class<? extends Exception>, ?> exceptionHandlers = Collections.emptyMap();
    private List<HttpMessageConverter<?>> httpMessageConverters;
    private MessageInterpolator messageInterpolator;
    private MessageSource messageSource;
    private boolean withDefaultHandlers = true;
    private boolean withDefaultMessageSource = true;

    public RestHandlerExceptionResolver getObject() {
        RestHandlerExceptionResolverBuilder builder = this.createBuilder().messageSource(this.messageSource).messageInterpolator(this.messageInterpolator).httpMessageConverters(this.httpMessageConverters).contentNegotiationManager(this.contentNegotiationManager).defaultContentType(this.defaultContentType).withDefaultHandlers(this.withDefaultHandlers).withDefaultMessageSource(this.withDefaultMessageSource);
        for (Map.Entry<Class<Exception>, ?> entry : this.exceptionHandlers.entrySet()) {
            Class<? extends Exception> exceptionClass = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof RestExceptionHandler) {
                builder.addHandler(exceptionClass, (RestExceptionHandler)value);
                continue;
            }
            builder.addErrorMessageHandler(exceptionClass, this.parseHttpStatus(value));
        }
        return builder.build();
    }

    public Class<?> getObjectType() {
        return RestHandlerExceptionResolver.class;
    }

    public boolean isSingleton() {
        return false;
    }

    RestHandlerExceptionResolverBuilder createBuilder() {
        return RestHandlerExceptionResolver.builder();
    }

    HttpStatus parseHttpStatus(Object value) {
        Assert.notNull((Object)value, (String)"Values of the exceptionHandlers map must not be null");
        if (value instanceof HttpStatus) {
            return (HttpStatus)value;
        }
        if (value instanceof Integer) {
            return HttpStatus.valueOf((int)((Integer)value));
        }
        if (value instanceof String) {
            return HttpStatus.valueOf((int)Integer.valueOf((String)value));
        }
        throw new IllegalArgumentException(String.format("Values of the exceptionHandlers maps must be instance of ErrorResponseFactory, HttpStatus, String, or int, but %s given", value.getClass()));
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setExceptionHandlers(Map<Class<? extends Exception>, ?> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public void setHttpMessageConverters(List<HttpMessageConverter<?>> httpMessageConverters) {
        this.httpMessageConverters = httpMessageConverters;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setWithDefaultHandlers(boolean withDefaultHandlers) {
        this.withDefaultHandlers = withDefaultHandlers;
    }

    public void setWithDefaultMessageSource(boolean withDefaultMessageSource) {
        this.withDefaultMessageSource = withDefaultMessageSource;
    }
}

