/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler.handlers;

import cz.jirutka.spring.exhandler.handlers.AbstractRestExceptionHandler;
import cz.jirutka.spring.exhandler.interpolators.MessageInterpolator;
import cz.jirutka.spring.exhandler.interpolators.MessageInterpolatorAware;
import cz.jirutka.spring.exhandler.interpolators.NoOpMessageInterpolator;
import cz.jirutka.spring.exhandler.interpolators.SpelMessageInterpolator;
import cz.jirutka.spring.exhandler.messages.ErrorMessage;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ErrorMessageRestExceptionHandler<E extends Exception>
extends AbstractRestExceptionHandler<E, ErrorMessage>
implements MessageSourceAware,
MessageInterpolatorAware {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorMessageRestExceptionHandler.class);
    protected static final String DEFAULT_PREFIX = "default";
    protected static final String TYPE_KEY = "type";
    protected static final String TITLE_KEY = "title";
    protected static final String DETAIL_KEY = "detail";
    protected static final String INSTANCE_KEY = "instance";
    private MessageSource messageSource;
    private MessageInterpolator interpolator = new SpelMessageInterpolator();

    public ErrorMessageRestExceptionHandler(Class<E> exceptionClass, HttpStatus status) {
        super(exceptionClass, status);
    }

    protected ErrorMessageRestExceptionHandler(HttpStatus status) {
        super(status);
    }

    @Override
    public ErrorMessage createBody(E ex, HttpServletRequest req) {
        ErrorMessage m = new ErrorMessage();
        m.setType(URI.create(this.resolveMessage(TYPE_KEY, ex, req)));
        m.setTitle(this.resolveMessage(TITLE_KEY, ex, req));
        m.setStatus(this.getStatus());
        m.setDetail(this.resolveMessage(DETAIL_KEY, ex, req));
        m.setInstance(URI.create(this.resolveMessage(INSTANCE_KEY, ex, req)));
        return m;
    }

    protected String resolveMessage(String key, E exception, HttpServletRequest request) {
        String template = this.getMessage(key, LocaleContextHolder.getLocale());
        HashMap<String, Object> vars = new HashMap<String, Object>(2);
        vars.put("ex", exception);
        vars.put("req", request);
        return this.interpolateMessage(template, vars);
    }

    protected String interpolateMessage(String messageTemplate, Map<String, Object> variables) {
        LOG.trace("Interpolating message '{}' with variables: {}", (Object)messageTemplate, variables);
        return this.interpolator.interpolate(messageTemplate, variables);
    }

    protected String getMessage(String key, Locale locale) {
        String prefix = this.getExceptionClass().getName();
        String message = this.messageSource.getMessage(String.valueOf(prefix) + "." + key, null, null, locale);
        if (message == null) {
            message = this.messageSource.getMessage("default." + key, null, null, locale);
        }
        if (message == null) {
            message = "";
            LOG.debug("No message found for {}.{}, nor {}.{}", new Object[]{prefix, key, DEFAULT_PREFIX, key});
        }
        return message;
    }

    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, (String)"messageSource must not be null");
        this.messageSource = messageSource;
    }

    @Override
    public void setMessageInterpolator(MessageInterpolator interpolator) {
        this.interpolator = interpolator != null ? interpolator : new NoOpMessageInterpolator();
    }
}

