/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler.interpolators;

import cz.jirutka.spring.exhandler.interpolators.MessageInterpolator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class SpelMessageInterpolator
implements MessageInterpolator {
    private static final Logger LOG = LoggerFactory.getLogger(SpelMessageInterpolator.class);
    private final EvaluationContext evalContext;

    public SpelMessageInterpolator(EvaluationContext evalContext) {
        Assert.notNull((Object)evalContext, (String)"EvaluationContext must not be null");
        this.evalContext = evalContext;
    }

    public SpelMessageInterpolator() {
        StandardEvaluationContext ctx = new StandardEvaluationContext();
        ctx.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.evalContext = ctx;
    }

    @Override
    public String interpolate(String messageTemplate, Map<String, Object> variables) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate must not be null");
        try {
            Expression expression = this.parser().parseExpression(messageTemplate, (ParserContext)new TemplateParserContext());
            return (String)expression.getValue(this.evalContext, variables, String.class);
        }
        catch (ExpressionException ex) {
            LOG.error("Failed to interpolate message template: {}", (Object)messageTemplate, (Object)ex);
            return "";
        }
    }

    ExpressionParser parser() {
        return new SpelExpressionParser();
    }
}

