/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.exhandler.support;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.util.ClassUtils;

public final class HttpMessageConverterUtils {
    private static final ClassLoader CLASSLOADER = HttpMessageConverterUtils.class.getClassLoader();

    private HttpMessageConverterUtils() {
    }

    public static boolean isJaxb2Present() {
        return ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)CLASSLOADER);
    }

    public static boolean isJackson2Present() {
        return ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)CLASSLOADER) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)CLASSLOADER);
    }

    @Deprecated
    public static boolean isJacksonPresent() {
        return ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)CLASSLOADER) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)CLASSLOADER);
    }

    public static List<HttpMessageConverter<?>> getDefaultHttpMessageConverters() {
        ArrayList converters = new ArrayList();
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        stringConverter.setWriteAcceptCharset(false);
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)stringConverter);
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        if (HttpMessageConverterUtils.isJaxb2Present()) {
            converters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (HttpMessageConverterUtils.isJackson2Present()) {
            converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        } else if (HttpMessageConverterUtils.isJacksonPresent()) {
            try {
                Class<?> clazz = Class.forName("org.springframework.http.converter.json.MappingJacksonHttpMessageConverter");
                converters.add((HttpMessageConverter)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return converters;
    }
}

