/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.internal.shaded.com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetCommitter<ID> {
    private static final Logger log = LoggerFactory.getLogger(OffsetCommitter.class);
    private final Map<ID, NavigableMap<Long, OffsetMeta>> waitingOffsets = Collections.synchronizedMap(new HashMap());
    private final long stateCommitWarningNanos;
    private final long autoCommitNanos;

    public OffsetCommitter() {
        this(60000000000L, Long.MAX_VALUE);
    }

    public OffsetCommitter(long staleCommitWarningNanos, long autoCommitNanos) {
        this.stateCommitWarningNanos = staleCommitWarningNanos;
        this.autoCommitNanos = autoCommitNanos;
    }

    public void register(ID id, long offset, int numActions, Callback commit) {
        NavigableMap current = this.waitingOffsets.computeIfAbsent(id, tmp -> Collections.synchronizedNavigableMap(new TreeMap()));
        log.debug("Registered offset {} for ID {} with {} actions", offset, id, numActions);
        current.put(offset, new OffsetMeta(numActions, commit));
        if (numActions == 0) {
            this.checkCommittable(id, current);
        }
    }

    public void confirm(ID id, long offset) {
        Map current = this.waitingOffsets.get(id);
        log.debug("Confirming processing of offset {} with ID {}", (Object)offset, (Object)id);
        if (current != null) {
            OffsetMeta meta = (OffsetMeta)current.get(offset);
            if (meta != null) {
                meta.decrement();
            }
            this.checkCommittable(id, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCommittable(ID id, Map<Long, OffsetMeta> current) {
        Map<Long, OffsetMeta> map = current;
        synchronized (map) {
            ArrayList<Map.Entry<Long, OffsetMeta>> committable = new ArrayList<Map.Entry<Long, OffsetMeta>>();
            for (Map.Entry<Long, OffsetMeta> e2 : current.entrySet()) {
                long age = e2.getValue().getNanoAge();
                if (age > this.autoCommitNanos) {
                    committable.add(e2);
                    log.warn("Auto adding offset {} of ID {} to comittable map due to age {} ns. The commit might have been lost. Verify your commit logic to remove this warning.", e2.getKey(), id, age);
                    continue;
                }
                if (e2.getValue().getActions() <= 0) {
                    committable.add(e2);
                    log.debug("Added offset {} of ID {} to committable map.", (Object)e2.getKey(), (Object)id);
                    continue;
                }
                if (age > this.stateCommitWarningNanos) {
                    log.warn("Offset {} ID {} was not committed in {} ns ({} actions missing). Please verify your commit logic!", e2.getKey(), id, age, e2.getValue().getActions());
                    break;
                }
                log.debug("Waiting for still non-committed offset {} in {}, {} actions missing", e2.getKey(), id, e2.getValue().getActions());
                break;
            }
            if (!committable.isEmpty()) {
                Map.Entry toCommit = (Map.Entry)committable.get(committable.size() - 1);
                committable.forEach(e -> {
                    OffsetMeta cfr_ignored_0 = (OffsetMeta)current.remove(e.getKey());
                });
                ((OffsetMeta)toCommit.getValue()).getCommit().apply();
            }
        }
    }

    public void clear(ID id, long offset) {
        Map current = this.waitingOffsets.get(id);
        if (current != null) {
            current.remove(offset);
        }
    }

    public void clear() {
        this.waitingOffsets.clear();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("waitingOffsets", this.waitingOffsets).toString();
    }

    static class OffsetMeta {
        AtomicInteger actions;
        Callback commit;
        final long createdNanos = System.nanoTime();

        OffsetMeta(int actions, Callback commit) {
            this.actions = new AtomicInteger(actions);
            this.commit = commit;
        }

        int getActions() {
            return this.actions.get();
        }

        long getNanoAge() {
            return System.nanoTime() - this.createdNanos;
        }

        synchronized void decrement() {
            if (this.actions.decrementAndGet() < 0) {
                log.error("Decremented too many, actions now {}", (Object)this.actions);
            }
        }

        public String toString() {
            return "OffsetMeta(actions=" + this.actions + ")";
        }

        public Callback getCommit() {
            return this.commit;
        }

        public long getCreatedNanos() {
            return this.createdNanos;
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void apply();
    }
}

