/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.direct.commitlog.Offset;
import cz.o2.proxima.internal.shaded.com.google.common.base.MoreObjects;
import cz.o2.proxima.storage.Partition;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class TopicOffset
implements Offset {
    private static final long serialVersionUID = 1L;
    private final int partition;
    private final long offset;
    private final long watermark;

    TopicOffset(int partition, long offset, long watermark) {
        this.partition = partition;
        this.offset = offset;
        this.watermark = watermark;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("offset", this.offset).add("watermark", this.watermark).toString();
    }

    public Partition getPartition() {
        return Partition.of((int)this.partition);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopicOffset) {
            TopicOffset other = (TopicOffset)obj;
            return other.partition == this.partition && other.offset == this.offset && other.watermark == this.watermark;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.offset, this.watermark);
    }

    static List<TopicOffset> fromMap(Map<Integer, Long> offsetMap, long watermark) {
        return offsetMap.entrySet().stream().map(e -> new TopicOffset((Integer)e.getKey(), (Long)e.getValue(), watermark)).collect(Collectors.toList());
    }

    public long getOffset() {
        return this.offset;
    }

    public long getWatermark() {
        return this.watermark;
    }
}

