/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.direct.commitlog.Offset;
import cz.o2.proxima.direct.kafka.TopicOffset;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.storage.UriUtil;
import java.net.URI;
import java.util.Collection;

class Utils {
    static String topic(URI uri) {
        String topic = UriUtil.getPathNormalized((URI)uri);
        if (topic.isEmpty()) {
            throw new IllegalArgumentException("Invalid path in URI " + uri);
        }
        return topic;
    }

    static void seekToOffsets(String topic, Collection<Offset> offsets, KafkaConsumer<?, ?> consumer) {
        offsets.forEach(o -> {
            TopicOffset to = (TopicOffset)o;
            TopicPartition tp = new TopicPartition(topic, o.getPartition().getId());
            if (to.getOffset() >= 0L) {
                consumer.seek(tp, to.getOffset());
            }
        });
    }

    private Utils() {
    }
}

