/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.ser.std;

import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.core.JsonGenerator;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.JavaType;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

