/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.RequestCompletionHandler;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.AuthenticationException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RequestHeader;

public class ClientResponse {
    private final RequestHeader requestHeader;
    private final RequestCompletionHandler callback;
    private final String destination;
    private final long receivedTimeMs;
    private final long latencyMs;
    private final boolean disconnected;
    private final UnsupportedVersionException versionMismatch;
    private final AuthenticationException authenticationException;
    private final AbstractResponse responseBody;

    public ClientResponse(RequestHeader requestHeader, RequestCompletionHandler callback, String destination, long createdTimeMs, long receivedTimeMs, boolean disconnected, UnsupportedVersionException versionMismatch, AuthenticationException authenticationException, AbstractResponse responseBody) {
        this.requestHeader = requestHeader;
        this.callback = callback;
        this.destination = destination;
        this.receivedTimeMs = receivedTimeMs;
        this.latencyMs = receivedTimeMs - createdTimeMs;
        this.disconnected = disconnected;
        this.versionMismatch = versionMismatch;
        this.authenticationException = authenticationException;
        this.responseBody = responseBody;
    }

    public long receivedTimeMs() {
        return this.receivedTimeMs;
    }

    public boolean wasDisconnected() {
        return this.disconnected;
    }

    public UnsupportedVersionException versionMismatch() {
        return this.versionMismatch;
    }

    public AuthenticationException authenticationException() {
        return this.authenticationException;
    }

    public RequestHeader requestHeader() {
        return this.requestHeader;
    }

    public String destination() {
        return this.destination;
    }

    public AbstractResponse responseBody() {
        return this.responseBody;
    }

    public boolean hasResponse() {
        return this.responseBody != null;
    }

    public long requestLatencyMs() {
        return this.latencyMs;
    }

    public void onComplete() {
        if (this.callback != null) {
            this.callback.onComplete(this);
        }
    }

    public String toString() {
        return "ClientResponse(receivedTimeMs=" + this.receivedTimeMs + ", latencyMs=" + this.latencyMs + ", disconnected=" + this.disconnected + ", requestHeader=" + this.requestHeader + ", responseBody=" + this.responseBody + ")";
    }
}

