/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin.ConfigEntry;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@InterfaceStability.Evolving
public class AlterConfigOp {
    private final ConfigEntry configEntry;
    private final OpType opType;

    public AlterConfigOp(ConfigEntry configEntry, OpType operationType) {
        this.configEntry = configEntry;
        this.opType = operationType;
    }

    public ConfigEntry configEntry() {
        return this.configEntry;
    }

    public OpType opType() {
        return this.opType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterConfigOp that = (AlterConfigOp)o;
        return this.opType == that.opType && Objects.equals(this.configEntry, that.configEntry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.opType, this.configEntry});
    }

    public String toString() {
        return "AlterConfigOp{opType=" + (Object)((Object)this.opType) + ", configEntry=" + this.configEntry + '}';
    }

    public static enum OpType {
        SET(0),
        DELETE(1),
        APPEND(2),
        SUBTRACT(3);

        private static final Map<Byte, OpType> OP_TYPES;
        private final byte id;

        private OpType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static OpType forId(byte id) {
            return OP_TYPES.get(id);
        }

        static {
            OP_TYPES = Collections.unmodifiableMap(Arrays.stream(OpType.values()).collect(Collectors.toMap(OpType::id, Function.identity())));
        }
    }
}

