/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin.KafkaAdminClient;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin.MemberToRemove;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.KafkaException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.KafkaFuture;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.ApiException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.LeaveGroupRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import java.util.Map;
import java.util.Set;

public class RemoveMembersFromConsumerGroupResult {
    private final KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future;
    private final Set<MemberToRemove> memberInfos;

    RemoveMembersFromConsumerGroupResult(KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future, Set<MemberToRemove> memberInfos) {
        this.future = future;
        this.memberInfos = memberInfos;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                if (this.removeAll()) {
                    for (Map.Entry entry : memberErrors.entrySet()) {
                        ApiException exception = ((Errors)((Object)((Object)entry.getValue()))).exception();
                        if (exception == null) continue;
                        KafkaException ex = new KafkaException("Encounter exception when trying to remove: " + entry.getKey(), exception);
                        result.completeExceptionally(ex);
                        return;
                    }
                } else {
                    for (MemberToRemove memberToRemove : this.memberInfos) {
                        if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, memberToRemove.toMemberIdentity(), result)) continue;
                        return;
                    }
                }
                result.complete(null);
            }
        });
        return result;
    }

    public KafkaFuture<Void> memberResult(MemberToRemove member) {
        if (this.removeAll()) {
            throw new IllegalArgumentException("The method: memberResult is not applicable in 'removeAll' mode");
        }
        if (!this.memberInfos.contains(member)) {
            throw new IllegalArgumentException("Member " + member + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, member.toMemberIdentity(), result)) {
                result.complete(null);
            }
        });
        return result;
    }

    private boolean maybeCompleteExceptionally(Map<LeaveGroupRequestData.MemberIdentity, Errors> memberErrors, LeaveGroupRequestData.MemberIdentity member, KafkaFutureImpl<Void> result) {
        Throwable exception = KafkaAdminClient.getSubLevelError(memberErrors, member, "Member \"" + member + "\" was not included in the removal response");
        if (exception != null) {
            result.completeExceptionally(exception);
            return true;
        }
        return false;
    }

    private boolean removeAll() {
        return this.memberInfos.isEmpty();
    }
}

