/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.producer.internals;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.ApiVersion;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.ApiVersions;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.ClientResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.NodeApiVersions;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.RequestCompletionHandler;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.CommitFailedException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.producer.internals.ProducerBatch;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.producer.internals.TransactionalRequestResult;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.KafkaException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.Node;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.AuthenticationException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.ClusterAuthorizationException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.GroupAuthorizationException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.InvalidPidMappingException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.OutOfOrderSequenceException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.ProducerFencedException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.RetriableException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.TopicAuthorizationException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnknownProducerIdException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.EndTxnRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.FindCoordinatorRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.InitProducerIdRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.DefaultRecordBatch;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.EndTxnRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.EndTxnResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.InitProducerIdRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.InitProducerIdResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ProduceResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.TransactionResult;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.PrimitiveRef;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ProducerIdAndEpoch;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class TransactionManager {
    private static final int NO_INFLIGHT_REQUEST_CORRELATION_ID = -1;
    private static final int NO_LAST_ACKED_SEQUENCE_NUMBER = -1;
    private final Logger log;
    private final String transactionalId;
    private final int transactionTimeoutMs;
    private final ApiVersions apiVersions;
    private final boolean autoDowngradeTxnCommit;
    private final TopicPartitionBookkeeper topicPartitionBookkeeper;
    private final Map<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> pendingTxnOffsetCommits;
    private final Map<TopicPartition, Integer> partitionsWithUnresolvedSequences;
    private final Set<TopicPartition> partitionsToRewriteSequences;
    private final PriorityQueue<TxnRequestHandler> pendingRequests;
    private final Set<TopicPartition> newPartitionsInTransaction;
    private final Set<TopicPartition> pendingPartitionsInTransaction;
    private final Set<TopicPartition> partitionsInTransaction;
    private TransactionalRequestResult pendingResult;
    private final long retryBackoffMs;
    private static final long ADD_PARTITIONS_RETRY_BACKOFF_MS = 20L;
    private int inFlightRequestCorrelationId = -1;
    private Node transactionCoordinator;
    private Node consumerGroupCoordinator;
    private boolean coordinatorSupportsBumpingEpoch;
    private volatile State currentState = State.UNINITIALIZED;
    private volatile RuntimeException lastError = null;
    private volatile ProducerIdAndEpoch producerIdAndEpoch = ProducerIdAndEpoch.NONE;
    private volatile boolean transactionStarted = false;
    private volatile boolean epochBumpRequired = false;

    public TransactionManager(LogContext logContext, String transactionalId, int transactionTimeoutMs, long retryBackoffMs, ApiVersions apiVersions, boolean autoDowngradeTxnCommit) {
        this.transactionalId = transactionalId;
        this.log = logContext.logger(TransactionManager.class);
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.transactionCoordinator = null;
        this.consumerGroupCoordinator = null;
        this.newPartitionsInTransaction = new HashSet<TopicPartition>();
        this.pendingPartitionsInTransaction = new HashSet<TopicPartition>();
        this.partitionsInTransaction = new HashSet<TopicPartition>();
        this.pendingRequests = new PriorityQueue<TxnRequestHandler>(10, Comparator.comparingInt(o -> o.priority().priority));
        this.pendingTxnOffsetCommits = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        this.partitionsWithUnresolvedSequences = new HashMap<TopicPartition, Integer>();
        this.partitionsToRewriteSequences = new HashSet<TopicPartition>();
        this.retryBackoffMs = retryBackoffMs;
        this.topicPartitionBookkeeper = new TopicPartitionBookkeeper();
        this.apiVersions = apiVersions;
        this.autoDowngradeTxnCommit = autoDowngradeTxnCommit;
    }

    public synchronized TransactionalRequestResult initializeTransactions() {
        return this.initializeTransactions(ProducerIdAndEpoch.NONE);
    }

    synchronized TransactionalRequestResult initializeTransactions(ProducerIdAndEpoch producerIdAndEpoch) {
        boolean isEpochBump = producerIdAndEpoch != ProducerIdAndEpoch.NONE;
        return this.handleCachedTransactionRequestResult(() -> {
            if (!isEpochBump) {
                this.transitionTo(State.INITIALIZING);
                this.log.info("Invoking InitProducerId for the first time in order to acquire a producer ID");
            } else {
                this.log.info("Invoking InitProducerId with current producer ID and epoch {} in order to bump the epoch", (Object)producerIdAndEpoch);
            }
            InitProducerIdRequestData requestData = new InitProducerIdRequestData().setTransactionalId(this.transactionalId).setTransactionTimeoutMs(this.transactionTimeoutMs).setProducerId(producerIdAndEpoch.producerId).setProducerEpoch(producerIdAndEpoch.epoch);
            InitProducerIdHandler handler = new InitProducerIdHandler(new InitProducerIdRequest.Builder(requestData), isEpochBump);
            this.enqueueRequest(handler);
            return handler.result;
        }, State.INITIALIZING);
    }

    public synchronized void beginTransaction() {
        this.ensureTransactional();
        this.maybeFailWithError();
        this.transitionTo(State.IN_TRANSACTION);
    }

    public synchronized TransactionalRequestResult beginCommit() {
        return this.handleCachedTransactionRequestResult(() -> {
            this.maybeFailWithError();
            this.transitionTo(State.COMMITTING_TRANSACTION);
            return this.beginCompletingTransaction(TransactionResult.COMMIT);
        }, State.COMMITTING_TRANSACTION);
    }

    public synchronized TransactionalRequestResult beginAbort() {
        return this.handleCachedTransactionRequestResult(() -> {
            if (this.currentState != State.ABORTABLE_ERROR) {
                this.maybeFailWithError();
            }
            this.transitionTo(State.ABORTING_TRANSACTION);
            this.newPartitionsInTransaction.clear();
            return this.beginCompletingTransaction(TransactionResult.ABORT);
        }, State.ABORTING_TRANSACTION);
    }

    private TransactionalRequestResult beginCompletingTransaction(TransactionResult transactionResult) {
        if (!this.newPartitionsInTransaction.isEmpty()) {
            this.enqueueRequest(this.addPartitionsToTransactionHandler());
        }
        if (!(this.lastError instanceof InvalidPidMappingException)) {
            EndTxnRequest.Builder builder = new EndTxnRequest.Builder(new EndTxnRequestData().setTransactionalId(this.transactionalId).setProducerId(this.producerIdAndEpoch.producerId).setProducerEpoch(this.producerIdAndEpoch.epoch).setCommitted(transactionResult.id));
            EndTxnHandler handler = new EndTxnHandler(builder);
            this.enqueueRequest(handler);
            if (!this.shouldBumpEpoch()) {
                return handler.result;
            }
        }
        return this.initializeTransactions(this.producerIdAndEpoch);
    }

    public synchronized TransactionalRequestResult sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        this.ensureTransactional();
        this.maybeFailWithError();
        if (this.currentState != State.IN_TRANSACTION) {
            throw new KafkaException("Cannot send offsets to transaction either because the producer is not in an active transaction");
        }
        this.log.debug("Begin adding offsets {} for consumer group {} to transaction", (Object)offsets, (Object)groupMetadata);
        AddOffsetsToTxnRequest.Builder builder = new AddOffsetsToTxnRequest.Builder(new AddOffsetsToTxnRequestData().setTransactionalId(this.transactionalId).setProducerId(this.producerIdAndEpoch.producerId).setProducerEpoch(this.producerIdAndEpoch.epoch).setGroupId(groupMetadata.groupId()));
        AddOffsetsToTxnHandler handler = new AddOffsetsToTxnHandler(builder, offsets, groupMetadata);
        this.enqueueRequest(handler);
        return handler.result;
    }

    public synchronized void maybeAddPartitionToTransaction(TopicPartition topicPartition) {
        if (this.isPartitionAdded(topicPartition) || this.isPartitionPendingAdd(topicPartition)) {
            return;
        }
        this.log.debug("Begin adding new partition {} to transaction", (Object)topicPartition);
        this.topicPartitionBookkeeper.addPartition(topicPartition);
        this.newPartitionsInTransaction.add(topicPartition);
    }

    RuntimeException lastError() {
        return this.lastError;
    }

    public synchronized void failIfNotReadyForSend() {
        if (this.hasError()) {
            throw new KafkaException("Cannot perform send because at least one previous transactional or idempotent request has failed with errors.", this.lastError);
        }
        if (this.isTransactional()) {
            if (!this.hasProducerId()) {
                throw new IllegalStateException("Cannot perform a 'send' before completing a call to initTransactions when transactions are enabled.");
            }
            if (this.currentState != State.IN_TRANSACTION) {
                throw new IllegalStateException("Cannot call send in state " + (Object)((Object)this.currentState));
            }
        }
    }

    synchronized boolean isSendToPartitionAllowed(TopicPartition tp) {
        if (this.hasFatalError()) {
            return false;
        }
        return !this.isTransactional() || this.partitionsInTransaction.contains(tp);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public boolean hasProducerId() {
        return this.producerIdAndEpoch.isValid();
    }

    public boolean isTransactional() {
        return this.transactionalId != null;
    }

    synchronized boolean hasPartitionsToAdd() {
        return !this.newPartitionsInTransaction.isEmpty() || !this.pendingPartitionsInTransaction.isEmpty();
    }

    synchronized boolean isCompleting() {
        return this.currentState == State.COMMITTING_TRANSACTION || this.currentState == State.ABORTING_TRANSACTION;
    }

    synchronized boolean hasError() {
        return this.currentState == State.ABORTABLE_ERROR || this.currentState == State.FATAL_ERROR;
    }

    synchronized boolean isAborting() {
        return this.currentState == State.ABORTING_TRANSACTION;
    }

    synchronized void transitionToAbortableError(RuntimeException exception) {
        if (this.currentState == State.ABORTING_TRANSACTION) {
            this.log.debug("Skipping transition to abortable error state since the transaction is already being aborted. Underlying exception: ", exception);
            return;
        }
        this.log.info("Transiting to abortable error state due to {}", (Object)exception.toString());
        this.transitionTo(State.ABORTABLE_ERROR, exception);
    }

    synchronized void transitionToFatalError(RuntimeException exception) {
        this.log.info("Transiting to fatal error state due to {}", (Object)exception.toString());
        this.transitionTo(State.FATAL_ERROR, exception);
        if (this.pendingResult != null) {
            this.pendingResult.fail(exception);
        }
    }

    synchronized boolean isPartitionAdded(TopicPartition partition) {
        return this.partitionsInTransaction.contains(partition);
    }

    synchronized boolean isPartitionPendingAdd(TopicPartition partition) {
        return this.newPartitionsInTransaction.contains(partition) || this.pendingPartitionsInTransaction.contains(partition);
    }

    ProducerIdAndEpoch producerIdAndEpoch() {
        return this.producerIdAndEpoch;
    }

    boolean producerIdOrEpochNotMatch(ProducerBatch batch) {
        ProducerIdAndEpoch idAndEpoch = this.producerIdAndEpoch;
        return idAndEpoch.producerId != batch.producerId() || idAndEpoch.epoch != batch.producerEpoch();
    }

    private void setProducerIdAndEpoch(ProducerIdAndEpoch producerIdAndEpoch) {
        this.log.info("ProducerId set to {} with epoch {}", (Object)producerIdAndEpoch.producerId, (Object)producerIdAndEpoch.epoch);
        this.producerIdAndEpoch = producerIdAndEpoch;
    }

    private void resetIdempotentProducerId() {
        if (this.isTransactional()) {
            throw new IllegalStateException("Cannot reset producer state for a transactional producer. You must either abort the ongoing transaction or reinitialize the transactional producer instead");
        }
        this.log.debug("Resetting idempotent producer ID. ID and epoch before reset are {}", (Object)this.producerIdAndEpoch);
        this.setProducerIdAndEpoch(ProducerIdAndEpoch.NONE);
        this.transitionTo(State.UNINITIALIZED);
    }

    private void resetSequenceForPartition(TopicPartition topicPartition) {
        this.topicPartitionBookkeeper.topicPartitions.remove(topicPartition);
        this.partitionsWithUnresolvedSequences.remove(topicPartition);
    }

    private void resetSequenceNumbers() {
        this.topicPartitionBookkeeper.reset();
        this.partitionsWithUnresolvedSequences.clear();
    }

    synchronized void requestEpochBumpForPartition(TopicPartition tp) {
        this.epochBumpRequired = true;
        this.partitionsToRewriteSequences.add(tp);
    }

    private boolean shouldBumpEpoch() {
        return this.epochBumpRequired;
    }

    private void bumpIdempotentProducerEpoch() {
        if (this.producerIdAndEpoch.epoch == Short.MAX_VALUE) {
            this.resetIdempotentProducerId();
        } else {
            this.setProducerIdAndEpoch(new ProducerIdAndEpoch(this.producerIdAndEpoch.producerId, (short)(this.producerIdAndEpoch.epoch + 1)));
            this.log.debug("Incremented producer epoch, current producer ID and epoch are now {}", (Object)this.producerIdAndEpoch);
        }
        for (TopicPartition topicPartition : this.partitionsToRewriteSequences) {
            this.topicPartitionBookkeeper.startSequencesAtBeginning(topicPartition, this.producerIdAndEpoch);
            this.partitionsWithUnresolvedSequences.remove(topicPartition);
        }
        this.partitionsToRewriteSequences.clear();
        this.epochBumpRequired = false;
    }

    synchronized void bumpIdempotentEpochAndResetIdIfNeeded() {
        if (!this.isTransactional()) {
            if (this.shouldBumpEpoch()) {
                this.bumpIdempotentProducerEpoch();
            }
            if (this.currentState != State.INITIALIZING && !this.hasProducerId()) {
                this.transitionTo(State.INITIALIZING);
                InitProducerIdRequestData requestData = new InitProducerIdRequestData().setTransactionalId(null).setTransactionTimeoutMs(Integer.MAX_VALUE);
                InitProducerIdHandler handler = new InitProducerIdHandler(new InitProducerIdRequest.Builder(requestData), false);
                this.enqueueRequest(handler);
            }
        }
    }

    synchronized Integer sequenceNumber(TopicPartition topicPartition) {
        if (!this.isTransactional()) {
            this.topicPartitionBookkeeper.addPartition(topicPartition);
        }
        return this.topicPartitionBookkeeper.getPartition(topicPartition).nextSequence;
    }

    synchronized void incrementSequenceNumber(TopicPartition topicPartition, int increment) {
        Integer currentSequence = this.sequenceNumber(topicPartition);
        currentSequence = DefaultRecordBatch.incrementSequence(currentSequence, increment);
        this.topicPartitionBookkeeper.getPartition(topicPartition).nextSequence = currentSequence;
    }

    synchronized void addInFlightBatch(ProducerBatch batch) {
        if (!batch.hasSequence()) {
            throw new IllegalStateException("Can't track batch for partition " + batch.topicPartition + " when sequence is not set.");
        }
        this.topicPartitionBookkeeper.getPartition(batch.topicPartition).inflightBatchesBySequence.add(batch);
    }

    synchronized int firstInFlightSequence(TopicPartition topicPartition) {
        if (!this.hasInflightBatches(topicPartition)) {
            return -1;
        }
        SortedSet inflightBatches = this.topicPartitionBookkeeper.getPartition(topicPartition).inflightBatchesBySequence;
        if (inflightBatches.isEmpty()) {
            return -1;
        }
        return ((ProducerBatch)inflightBatches.first()).baseSequence();
    }

    synchronized ProducerBatch nextBatchBySequence(TopicPartition topicPartition) {
        SortedSet queue = this.topicPartitionBookkeeper.getPartition(topicPartition).inflightBatchesBySequence;
        return queue.isEmpty() ? null : (ProducerBatch)queue.first();
    }

    synchronized void removeInFlightBatch(ProducerBatch batch) {
        if (this.hasInflightBatches(batch.topicPartition)) {
            this.topicPartitionBookkeeper.getPartition(batch.topicPartition).inflightBatchesBySequence.remove(batch);
        }
    }

    private int maybeUpdateLastAckedSequence(TopicPartition topicPartition, int sequence) {
        int lastAckedSequence = this.lastAckedSequence(topicPartition).orElse(-1);
        if (sequence > lastAckedSequence) {
            this.topicPartitionBookkeeper.getPartition(topicPartition).lastAckedSequence = sequence;
            return sequence;
        }
        return lastAckedSequence;
    }

    synchronized OptionalInt lastAckedSequence(TopicPartition topicPartition) {
        return this.topicPartitionBookkeeper.lastAckedSequence(topicPartition);
    }

    synchronized OptionalLong lastAckedOffset(TopicPartition topicPartition) {
        return this.topicPartitionBookkeeper.lastAckedOffset(topicPartition);
    }

    private void updateLastAckedOffset(ProduceResponse.PartitionResponse response, ProducerBatch batch) {
        if (response.baseOffset == -1L) {
            return;
        }
        long lastOffset = response.baseOffset + (long)batch.recordCount - 1L;
        OptionalLong lastAckedOffset = this.lastAckedOffset(batch.topicPartition);
        if (!lastAckedOffset.isPresent() && !this.isTransactional()) {
            this.topicPartitionBookkeeper.addPartition(batch.topicPartition);
        }
        if (lastOffset > lastAckedOffset.orElse(-1L)) {
            this.topicPartitionBookkeeper.getPartition(batch.topicPartition).lastAckedOffset = lastOffset;
        } else {
            this.log.trace("Partition {} keeps lastOffset at {}", (Object)batch.topicPartition, (Object)lastOffset);
        }
    }

    public synchronized void handleCompletedBatch(ProducerBatch batch, ProduceResponse.PartitionResponse response) {
        int lastAckedSequence = this.maybeUpdateLastAckedSequence(batch.topicPartition, batch.lastSequence());
        this.log.debug("ProducerId: {}; Set last ack'd sequence number for topic-partition {} to {}", batch.producerId(), batch.topicPartition, lastAckedSequence);
        this.updateLastAckedOffset(response, batch);
        this.removeInFlightBatch(batch);
        if (this.producerIdOrEpochNotMatch(batch) && !this.hasInflightBatches(batch.topicPartition)) {
            this.topicPartitionBookkeeper.startSequencesAtBeginning(batch.topicPartition, this.producerIdAndEpoch);
        }
    }

    private void maybeTransitionToErrorState(RuntimeException exception) {
        if (exception instanceof ClusterAuthorizationException || exception instanceof TransactionalIdAuthorizationException || exception instanceof ProducerFencedException || exception instanceof UnsupportedVersionException) {
            this.transitionToFatalError(exception);
        } else if (this.isTransactional()) {
            if (this.canBumpEpoch() && !this.isCompleting()) {
                this.epochBumpRequired = true;
            }
            this.transitionToAbortableError(exception);
        }
    }

    synchronized void handleFailedBatch(ProducerBatch batch, RuntimeException exception, boolean adjustSequenceNumbers) {
        this.maybeTransitionToErrorState(exception);
        this.removeInFlightBatch(batch);
        if (this.hasFatalError()) {
            this.log.debug("Ignoring batch {} with producer id {}, epoch {}, and sequence number {} since the producer is already in fatal error state", batch, batch.producerId(), batch.producerEpoch(), batch.baseSequence(), exception);
            return;
        }
        if (this.producerIdOrEpochNotMatch(batch)) {
            this.log.debug("Ignoring failed batch {} with producer id {}, epoch {}, and sequence number {} since the producerId has been reset internally", batch, batch.producerId(), batch.producerEpoch(), batch.baseSequence(), exception);
            return;
        }
        if (exception instanceof OutOfOrderSequenceException && !this.isTransactional()) {
            this.log.error("The broker returned {} for topic-partition {} with producerId {}, epoch {}, and sequence number {}", exception, batch.topicPartition, batch.producerId(), batch.producerEpoch(), batch.baseSequence());
            this.requestEpochBumpForPartition(batch.topicPartition);
        } else if (exception instanceof UnknownProducerIdException) {
            this.resetSequenceForPartition(batch.topicPartition);
        } else if (adjustSequenceNumbers) {
            if (!this.isTransactional()) {
                this.requestEpochBumpForPartition(batch.topicPartition);
            } else {
                this.adjustSequencesDueToFailedBatch(batch);
            }
        }
    }

    private void adjustSequencesDueToFailedBatch(ProducerBatch batch) {
        if (!this.topicPartitionBookkeeper.contains(batch.topicPartition)) {
            return;
        }
        this.log.debug("producerId: {}, send to partition {} failed fatally. Reducing future sequence numbers by {}", batch.producerId(), batch.topicPartition, batch.recordCount);
        int currentSequence = this.sequenceNumber(batch.topicPartition);
        if ((currentSequence -= batch.recordCount) < 0) {
            throw new IllegalStateException("Sequence number for partition " + batch.topicPartition + " is going to become negative: " + currentSequence);
        }
        this.setNextSequence(batch.topicPartition, currentSequence);
        this.topicPartitionBookkeeper.getPartition(batch.topicPartition).resetSequenceNumbers(inFlightBatch -> {
            if (inFlightBatch.baseSequence() < batch.baseSequence()) {
                return;
            }
            int newSequence = inFlightBatch.baseSequence() - batch.recordCount;
            if (newSequence < 0) {
                throw new IllegalStateException("Sequence number for batch with sequence " + inFlightBatch.baseSequence() + " for partition " + batch.topicPartition + " is going to become negative: " + newSequence);
            }
            this.log.info("Resetting sequence number of batch with current sequence {} for partition {} to {}", inFlightBatch.baseSequence(), batch.topicPartition, newSequence);
            inFlightBatch.resetProducerState(new ProducerIdAndEpoch(inFlightBatch.producerId(), inFlightBatch.producerEpoch()), newSequence, inFlightBatch.isTransactional());
        });
    }

    synchronized boolean hasInflightBatches(TopicPartition topicPartition) {
        return this.topicPartitionBookkeeper.contains(topicPartition) && !this.topicPartitionBookkeeper.getPartition(topicPartition).inflightBatchesBySequence.isEmpty();
    }

    synchronized boolean hasUnresolvedSequences() {
        return !this.partitionsWithUnresolvedSequences.isEmpty();
    }

    synchronized boolean hasUnresolvedSequence(TopicPartition topicPartition) {
        return this.partitionsWithUnresolvedSequences.containsKey(topicPartition);
    }

    synchronized void markSequenceUnresolved(ProducerBatch batch) {
        int nextSequence = batch.lastSequence() + 1;
        this.partitionsWithUnresolvedSequences.compute(batch.topicPartition, (k, v) -> v == null ? nextSequence : Math.max(v, nextSequence));
        this.log.debug("Marking partition {} unresolved with next sequence number {}", (Object)batch.topicPartition, (Object)this.partitionsWithUnresolvedSequences.get(batch.topicPartition));
    }

    synchronized void maybeResolveSequences() {
        Iterator<TopicPartition> iter = this.partitionsWithUnresolvedSequences.keySet().iterator();
        while (iter.hasNext()) {
            TopicPartition topicPartition = iter.next();
            if (this.hasInflightBatches(topicPartition)) continue;
            if (this.isNextSequence(topicPartition, this.sequenceNumber(topicPartition))) {
                iter.remove();
                continue;
            }
            if (this.isTransactional()) {
                KafkaException exception;
                String unackedMessagesErr = "The client hasn't received acknowledgment for some previously sent messages and can no longer retry them. ";
                if (this.canBumpEpoch()) {
                    this.epochBumpRequired = true;
                    exception = new KafkaException(unackedMessagesErr + "It is safe to abort the transaction and continue.");
                    this.transitionToAbortableError(exception);
                } else {
                    exception = new KafkaException(unackedMessagesErr + "It isn't safe to continue.");
                    this.transitionToFatalError(exception);
                }
            } else {
                this.log.info("No inflight batches remaining for {}, last ack'd sequence for partition is {}, next sequence is {}. Going to bump epoch and reset sequence numbers.", topicPartition, this.lastAckedSequence(topicPartition).orElse(-1), this.sequenceNumber(topicPartition));
                this.requestEpochBumpForPartition(topicPartition);
            }
            iter.remove();
        }
    }

    private boolean isNextSequence(TopicPartition topicPartition, int sequence) {
        return sequence - this.lastAckedSequence(topicPartition).orElse(-1) == 1;
    }

    private void setNextSequence(TopicPartition topicPartition, int sequence) {
        this.topicPartitionBookkeeper.getPartition(topicPartition).nextSequence = sequence;
    }

    private boolean isNextSequenceForUnresolvedPartition(TopicPartition topicPartition, int sequence) {
        return this.hasUnresolvedSequence(topicPartition) && sequence == this.partitionsWithUnresolvedSequences.get(topicPartition);
    }

    synchronized TxnRequestHandler nextRequest(boolean hasIncompleteBatches) {
        TxnRequestHandler nextRequestHandler;
        if (!this.newPartitionsInTransaction.isEmpty()) {
            this.enqueueRequest(this.addPartitionsToTransactionHandler());
        }
        if ((nextRequestHandler = this.pendingRequests.peek()) == null) {
            return null;
        }
        if (nextRequestHandler.isEndTxn() && hasIncompleteBatches) {
            return null;
        }
        this.pendingRequests.poll();
        if (this.maybeTerminateRequestWithError(nextRequestHandler)) {
            this.log.trace("Not sending transactional request {} because we are in an error state", (Object)nextRequestHandler.requestBuilder());
            return null;
        }
        if (nextRequestHandler.isEndTxn() && !this.transactionStarted) {
            nextRequestHandler.result.done();
            if (this.currentState != State.FATAL_ERROR) {
                this.log.debug("Not sending EndTxn for completed transaction since no partitions or offsets were successfully added");
                this.completeTransaction();
            }
            nextRequestHandler = this.pendingRequests.poll();
        }
        if (nextRequestHandler != null) {
            this.log.trace("Request {} dequeued for sending", (Object)nextRequestHandler.requestBuilder());
        }
        return nextRequestHandler;
    }

    synchronized void retry(TxnRequestHandler request) {
        request.setRetry();
        this.enqueueRequest(request);
    }

    synchronized void authenticationFailed(AuthenticationException e) {
        for (TxnRequestHandler request : this.pendingRequests) {
            request.fatalError(e);
        }
    }

    synchronized void close() {
        KafkaException shutdownException = new KafkaException("The producer closed forcefully");
        this.pendingRequests.forEach(handler -> handler.fatalError(shutdownException));
        if (this.pendingResult != null) {
            this.pendingResult.fail(shutdownException);
        }
    }

    Node coordinator(FindCoordinatorRequest.CoordinatorType type) {
        switch (type) {
            case GROUP: {
                return this.consumerGroupCoordinator;
            }
            case TRANSACTION: {
                return this.transactionCoordinator;
            }
        }
        throw new IllegalStateException("Received an invalid coordinator type: " + (Object)((Object)type));
    }

    void lookupCoordinator(TxnRequestHandler request) {
        this.lookupCoordinator(request.coordinatorType(), request.coordinatorKey());
    }

    void setInFlightCorrelationId(int correlationId) {
        this.inFlightRequestCorrelationId = correlationId;
    }

    private void clearInFlightCorrelationId() {
        this.inFlightRequestCorrelationId = -1;
    }

    boolean hasInFlightRequest() {
        return this.inFlightRequestCorrelationId != -1;
    }

    boolean hasFatalError() {
        return this.currentState == State.FATAL_ERROR;
    }

    boolean hasAbortableError() {
        return this.currentState == State.ABORTABLE_ERROR;
    }

    synchronized boolean transactionContainsPartition(TopicPartition topicPartition) {
        return this.partitionsInTransaction.contains(topicPartition);
    }

    synchronized boolean hasPendingOffsetCommits() {
        return !this.pendingTxnOffsetCommits.isEmpty();
    }

    synchronized boolean hasPendingRequests() {
        return !this.pendingRequests.isEmpty();
    }

    synchronized boolean hasOngoingTransaction() {
        return this.currentState == State.IN_TRANSACTION || this.isCompleting() || this.hasAbortableError();
    }

    synchronized boolean canRetry(ProduceResponse.PartitionResponse response, ProducerBatch batch) {
        Errors error = response.error;
        if (error == Errors.UNKNOWN_PRODUCER_ID) {
            if (response.logStartOffset == -1L) {
                return true;
            }
            if (batch.sequenceHasBeenReset()) {
                return true;
            }
            if (this.lastAckedOffset(batch.topicPartition).orElse(-1L) < response.logStartOffset) {
                if (this.isTransactional()) {
                    this.topicPartitionBookkeeper.startSequencesAtBeginning(batch.topicPartition, this.producerIdAndEpoch);
                } else {
                    this.requestEpochBumpForPartition(batch.topicPartition);
                }
                return true;
            }
            if (!this.isTransactional()) {
                this.requestEpochBumpForPartition(batch.topicPartition);
                return true;
            }
        } else if (error == Errors.OUT_OF_ORDER_SEQUENCE_NUMBER) {
            if (!(this.hasUnresolvedSequence(batch.topicPartition) || !batch.sequenceHasBeenReset() && this.isNextSequence(batch.topicPartition, batch.baseSequence()))) {
                return true;
            }
            if (!this.isTransactional()) {
                if (!this.hasUnresolvedSequence(batch.topicPartition) || this.isNextSequenceForUnresolvedPartition(batch.topicPartition, batch.baseSequence())) {
                    this.requestEpochBumpForPartition(batch.topicPartition);
                }
                return true;
            }
        }
        return error.exception() instanceof RetriableException;
    }

    synchronized boolean isReady() {
        return this.isTransactional() && this.currentState == State.READY;
    }

    void handleCoordinatorReady() {
        NodeApiVersions nodeApiVersions = this.transactionCoordinator != null ? this.apiVersions.get(this.transactionCoordinator.idString()) : null;
        ApiVersion initProducerIdVersion = nodeApiVersions != null ? nodeApiVersions.apiVersion(ApiKeys.INIT_PRODUCER_ID) : null;
        this.coordinatorSupportsBumpingEpoch = initProducerIdVersion != null && initProducerIdVersion.maxVersion >= 3;
    }

    private void transitionTo(State target) {
        this.transitionTo(target, null);
    }

    private void transitionTo(State target, RuntimeException error) {
        if (!this.currentState.isTransitionValid(this.currentState, target)) {
            String idString = this.transactionalId == null ? "" : "TransactionalId " + this.transactionalId + ": ";
            throw new KafkaException(idString + "Invalid transition attempted from state " + this.currentState.name() + " to state " + target.name());
        }
        if (target == State.FATAL_ERROR || target == State.ABORTABLE_ERROR) {
            if (error == null) {
                throw new IllegalArgumentException("Cannot transition to " + (Object)((Object)target) + " with a null exception");
            }
            this.lastError = error;
        } else {
            this.lastError = null;
        }
        if (this.lastError != null) {
            this.log.debug("Transition from state {} to error state {}", new Object[]{this.currentState, target, this.lastError});
        } else {
            this.log.debug("Transition from state {} to {}", (Object)this.currentState, (Object)target);
        }
        this.currentState = target;
    }

    private void ensureTransactional() {
        if (!this.isTransactional()) {
            throw new IllegalStateException("Transactional method invoked on a non-transactional producer.");
        }
    }

    private void maybeFailWithError() {
        if (this.hasError()) {
            if (this.lastError instanceof ProducerFencedException) {
                throw new ProducerFencedException("The producer has been rejected from the broker because it tried to use an old epoch with the transactionalId");
            }
            throw new KafkaException("Cannot execute transactional method because we are in an error state", this.lastError);
        }
    }

    private boolean maybeTerminateRequestWithError(TxnRequestHandler requestHandler) {
        if (this.hasError()) {
            if (this.hasAbortableError() && requestHandler instanceof FindCoordinatorHandler) {
                return false;
            }
            requestHandler.fail(this.lastError);
            return true;
        }
        return false;
    }

    private void enqueueRequest(TxnRequestHandler requestHandler) {
        this.log.debug("Enqueuing transactional request {}", (Object)requestHandler.requestBuilder());
        this.pendingRequests.add(requestHandler);
    }

    private void lookupCoordinator(FindCoordinatorRequest.CoordinatorType type, String coordinatorKey) {
        switch (type) {
            case GROUP: {
                this.consumerGroupCoordinator = null;
                break;
            }
            case TRANSACTION: {
                this.transactionCoordinator = null;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid coordinator type: " + (Object)((Object)type));
            }
        }
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(type.id()).setKey(coordinatorKey));
        this.enqueueRequest(new FindCoordinatorHandler(builder));
    }

    private TxnRequestHandler addPartitionsToTransactionHandler() {
        this.pendingPartitionsInTransaction.addAll(this.newPartitionsInTransaction);
        this.newPartitionsInTransaction.clear();
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(this.transactionalId, this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, new ArrayList<TopicPartition>(this.pendingPartitionsInTransaction));
        return new AddPartitionsToTxnHandler(builder);
    }

    private TxnOffsetCommitHandler txnOffsetCommitHandler(TransactionalRequestResult result, Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            TxnOffsetCommitRequest.CommittedOffset committedOffset = new TxnOffsetCommitRequest.CommittedOffset(offsetAndMetadata.offset(), offsetAndMetadata.metadata(), offsetAndMetadata.leaderEpoch());
            this.pendingTxnOffsetCommits.put(entry.getKey(), committedOffset);
        }
        TxnOffsetCommitRequest.Builder builder = new TxnOffsetCommitRequest.Builder(this.transactionalId, groupMetadata.groupId(), this.producerIdAndEpoch.producerId, this.producerIdAndEpoch.epoch, this.pendingTxnOffsetCommits, groupMetadata.memberId(), groupMetadata.generationId(), groupMetadata.groupInstanceId(), this.autoDowngradeTxnCommit);
        return new TxnOffsetCommitHandler(result, builder);
    }

    private TransactionalRequestResult handleCachedTransactionRequestResult(Supplier<TransactionalRequestResult> transactionalRequestResultSupplier, State targetState) {
        this.ensureTransactional();
        if (this.pendingResult != null && this.currentState == targetState) {
            TransactionalRequestResult result = this.pendingResult;
            if (result.isCompleted()) {
                this.pendingResult = null;
            }
            return result;
        }
        this.pendingResult = transactionalRequestResultSupplier.get();
        return this.pendingResult;
    }

    boolean canBumpEpoch() {
        if (!this.isTransactional()) {
            return true;
        }
        return this.coordinatorSupportsBumpingEpoch;
    }

    private void completeTransaction() {
        if (this.epochBumpRequired) {
            this.transitionTo(State.INITIALIZING);
        } else {
            this.transitionTo(State.READY);
        }
        this.lastError = null;
        this.epochBumpRequired = false;
        this.transactionStarted = false;
        this.newPartitionsInTransaction.clear();
        this.pendingPartitionsInTransaction.clear();
        this.partitionsInTransaction.clear();
    }

    private boolean isFatalException(Errors error) {
        return error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED || error == Errors.INVALID_PRODUCER_EPOCH || error == Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT;
    }

    private class TxnOffsetCommitHandler
    extends TxnRequestHandler {
        private final TxnOffsetCommitRequest.Builder builder;

        private TxnOffsetCommitHandler(TransactionalRequestResult result, TxnOffsetCommitRequest.Builder builder) {
            super(result);
            this.builder = builder;
        }

        TxnOffsetCommitRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return FindCoordinatorRequest.CoordinatorType.GROUP;
        }

        @Override
        String coordinatorKey() {
            return this.builder.data.groupId();
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            TxnOffsetCommitResponse txnOffsetCommitResponse = (TxnOffsetCommitResponse)response;
            boolean coordinatorReloaded = false;
            Map<TopicPartition, Errors> errors = txnOffsetCommitResponse.errors();
            TransactionManager.this.log.debug("Received TxnOffsetCommit response for consumer group {}: {}", (Object)this.builder.data.groupId(), (Object)errors);
            for (Map.Entry<TopicPartition, Errors> entry : errors.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                Errors error = entry.getValue();
                if (error == Errors.NONE) {
                    TransactionManager.this.pendingTxnOffsetCommits.remove(topicPartition);
                    continue;
                }
                if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR || error == Errors.REQUEST_TIMED_OUT) {
                    if (coordinatorReloaded) continue;
                    coordinatorReloaded = true;
                    TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.GROUP, this.builder.data.groupId());
                    continue;
                }
                if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION || error == Errors.COORDINATOR_LOAD_IN_PROGRESS) continue;
                if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                    this.abortableError(GroupAuthorizationException.forGroupId(this.builder.data.groupId()));
                    break;
                }
                if (error == Errors.FENCED_INSTANCE_ID) {
                    this.abortableError(error.exception());
                    break;
                }
                if (error == Errors.UNKNOWN_MEMBER_ID || error == Errors.ILLEGAL_GENERATION) {
                    this.abortableError(new CommitFailedException("Transaction offset Commit failed due to consumer group metadata mismatch: " + error.exception().getMessage()));
                    break;
                }
                if (TransactionManager.this.isFatalException(error)) {
                    this.fatalError(error.exception());
                    break;
                }
                this.fatalError(new KafkaException("Unexpected error in TxnOffsetCommitResponse: " + error.message()));
                break;
            }
            if (this.result.isCompleted()) {
                TransactionManager.this.pendingTxnOffsetCommits.clear();
            } else if (TransactionManager.this.pendingTxnOffsetCommits.isEmpty()) {
                this.result.done();
            } else {
                this.reenqueue();
            }
        }
    }

    private class AddOffsetsToTxnHandler
    extends TxnRequestHandler {
        private final AddOffsetsToTxnRequest.Builder builder;
        private final Map<TopicPartition, OffsetAndMetadata> offsets;
        private final ConsumerGroupMetadata groupMetadata;

        private AddOffsetsToTxnHandler(AddOffsetsToTxnRequest.Builder builder, Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
            super("AddOffsetsToTxn");
            this.builder = builder;
            this.offsets = offsets;
            this.groupMetadata = groupMetadata;
        }

        AddOffsetsToTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            AddOffsetsToTxnResponse addOffsetsToTxnResponse = (AddOffsetsToTxnResponse)response;
            Errors error = Errors.forCode(addOffsetsToTxnResponse.data.errorCode());
            if (error == Errors.NONE) {
                TransactionManager.this.log.debug("Successfully added partition for consumer group {} to transaction", (Object)this.builder.data.groupId());
                TransactionManager.this.pendingRequests.add(TransactionManager.this.txnOffsetCommitHandler(this.result, this.offsets, this.groupMetadata));
                TransactionManager.this.transactionStarted = true;
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.UNKNOWN_PRODUCER_ID || error == Errors.INVALID_PRODUCER_ID_MAPPING) {
                this.abortableErrorIfPossible(error.exception());
            } else if (error == Errors.INVALID_PRODUCER_EPOCH) {
                this.fatalError(error.exception());
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (error == Errors.GROUP_AUTHORIZATION_FAILED) {
                this.abortableError(GroupAuthorizationException.forGroupId(this.builder.data.groupId()));
            } else {
                this.fatalError(new KafkaException("Unexpected error in AddOffsetsToTxnResponse: " + error.message()));
            }
        }
    }

    private class EndTxnHandler
    extends TxnRequestHandler {
        private final EndTxnRequest.Builder builder;

        private EndTxnHandler(EndTxnRequest.Builder builder) {
            super("EndTxn(" + builder.data.committed() + ")");
            this.builder = builder;
        }

        EndTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.END_TXN;
        }

        @Override
        boolean isEndTxn() {
            return true;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            EndTxnResponse endTxnResponse = (EndTxnResponse)response;
            Errors error = endTxnResponse.error();
            if (error == Errors.NONE) {
                TransactionManager.this.completeTransaction();
                this.result.done();
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.INVALID_PRODUCER_EPOCH) {
                this.fatalError(error.exception());
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (error == Errors.INVALID_TXN_STATE) {
                this.fatalError(error.exception());
            } else if (error == Errors.UNKNOWN_PRODUCER_ID || error == Errors.INVALID_PRODUCER_ID_MAPPING) {
                this.abortableErrorIfPossible(error.exception());
            } else {
                this.fatalError(new KafkaException("Unhandled error in EndTxnResponse: " + error.message()));
            }
        }
    }

    private class FindCoordinatorHandler
    extends TxnRequestHandler {
        private final FindCoordinatorRequest.Builder builder;

        private FindCoordinatorHandler(FindCoordinatorRequest.Builder builder) {
            super("FindCoordinator");
            this.builder = builder;
        }

        FindCoordinatorRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.FIND_COORDINATOR;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return null;
        }

        @Override
        String coordinatorKey() {
            return null;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            FindCoordinatorResponse findCoordinatorResponse = (FindCoordinatorResponse)response;
            Errors error = findCoordinatorResponse.error();
            FindCoordinatorRequest.CoordinatorType coordinatorType = FindCoordinatorRequest.CoordinatorType.forId(this.builder.data().keyType());
            if (error == Errors.NONE) {
                Node node = findCoordinatorResponse.node();
                switch (coordinatorType) {
                    case GROUP: {
                        TransactionManager.this.consumerGroupCoordinator = node;
                        break;
                    }
                    case TRANSACTION: {
                        TransactionManager.this.transactionCoordinator = node;
                    }
                }
                this.result.done();
                TransactionManager.this.log.info("Discovered {} coordinator {}", (Object)coordinatorType.toString().toLowerCase(Locale.ROOT), (Object)node);
            } else if (error == Errors.COORDINATOR_NOT_AVAILABLE) {
                this.reenqueue();
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else if (findCoordinatorResponse.error() == Errors.GROUP_AUTHORIZATION_FAILED) {
                this.abortableError(GroupAuthorizationException.forGroupId(this.builder.data().key()));
            } else {
                this.fatalError(new KafkaException(String.format("Could not find a coordinator with type %s with key %s due tounexpected error: %s", new Object[]{coordinatorType, this.builder.data().key(), findCoordinatorResponse.data().errorMessage()})));
            }
        }
    }

    private class AddPartitionsToTxnHandler
    extends TxnRequestHandler {
        private final AddPartitionsToTxnRequest.Builder builder;
        private long retryBackoffMs;

        private AddPartitionsToTxnHandler(AddPartitionsToTxnRequest.Builder builder) {
            super("AddPartitionsToTxn");
            this.builder = builder;
            this.retryBackoffMs = TransactionManager.this.retryBackoffMs;
        }

        AddPartitionsToTxnRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return Priority.ADD_PARTITIONS_OR_OFFSETS;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            AddPartitionsToTxnResponse addPartitionsToTxnResponse = (AddPartitionsToTxnResponse)response;
            Map<TopicPartition, Errors> errors = addPartitionsToTxnResponse.errors();
            boolean hasPartitionErrors = false;
            HashSet<String> unauthorizedTopics = new HashSet<String>();
            this.retryBackoffMs = TransactionManager.this.retryBackoffMs;
            for (Map.Entry<TopicPartition, Errors> topicPartitionErrorEntry : errors.entrySet()) {
                TopicPartition topicPartition = topicPartitionErrorEntry.getKey();
                Errors error = topicPartitionErrorEntry.getValue();
                if (error == Errors.NONE) continue;
                if (error == Errors.COORDINATOR_NOT_AVAILABLE || error == Errors.NOT_COORDINATOR) {
                    TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                    this.reenqueue();
                    return;
                }
                if (error == Errors.CONCURRENT_TRANSACTIONS) {
                    this.maybeOverrideRetryBackoffMs();
                    this.reenqueue();
                    return;
                }
                if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
                    this.reenqueue();
                    return;
                }
                if (error == Errors.INVALID_PRODUCER_EPOCH) {
                    this.fatalError(error.exception());
                    return;
                }
                if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED) {
                    this.fatalError(error.exception());
                    return;
                }
                if (error == Errors.INVALID_TXN_STATE) {
                    this.fatalError(new KafkaException(error.exception()));
                    return;
                }
                if (error == Errors.TOPIC_AUTHORIZATION_FAILED) {
                    unauthorizedTopics.add(topicPartition.topic());
                    continue;
                }
                if (error == Errors.OPERATION_NOT_ATTEMPTED) {
                    TransactionManager.this.log.debug("Did not attempt to add partition {} to transaction because other partitions in the batch had errors.", (Object)topicPartition);
                    hasPartitionErrors = true;
                    continue;
                }
                if (error == Errors.UNKNOWN_PRODUCER_ID || error == Errors.INVALID_PRODUCER_ID_MAPPING) {
                    this.abortableErrorIfPossible(error.exception());
                    return;
                }
                TransactionManager.this.log.error("Could not add partition {} due to unexpected error {}", (Object)topicPartition, (Object)error);
                hasPartitionErrors = true;
            }
            Set<TopicPartition> partitions = errors.keySet();
            TransactionManager.this.pendingPartitionsInTransaction.removeAll(partitions);
            if (!unauthorizedTopics.isEmpty()) {
                this.abortableError(new TopicAuthorizationException(unauthorizedTopics));
            } else if (hasPartitionErrors) {
                this.abortableError(new KafkaException("Could not add partitions to transaction due to errors: " + errors));
            } else {
                TransactionManager.this.log.debug("Successfully added partitions {} to transaction", (Object)partitions);
                TransactionManager.this.partitionsInTransaction.addAll(partitions);
                TransactionManager.this.transactionStarted = true;
                this.result.done();
            }
        }

        @Override
        public long retryBackoffMs() {
            return Math.min(TransactionManager.this.retryBackoffMs, this.retryBackoffMs);
        }

        private void maybeOverrideRetryBackoffMs() {
            if (TransactionManager.this.partitionsInTransaction.isEmpty()) {
                this.retryBackoffMs = 20L;
            }
        }
    }

    private class InitProducerIdHandler
    extends TxnRequestHandler {
        private final InitProducerIdRequest.Builder builder;
        private final boolean isEpochBump;

        private InitProducerIdHandler(InitProducerIdRequest.Builder builder, boolean isEpochBump) {
            super("InitProducerId");
            this.builder = builder;
            this.isEpochBump = isEpochBump;
        }

        InitProducerIdRequest.Builder requestBuilder() {
            return this.builder;
        }

        @Override
        Priority priority() {
            return this.isEpochBump ? Priority.EPOCH_BUMP : Priority.INIT_PRODUCER_ID;
        }

        @Override
        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            if (TransactionManager.this.isTransactional()) {
                return FindCoordinatorRequest.CoordinatorType.TRANSACTION;
            }
            return null;
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            InitProducerIdResponse initProducerIdResponse = (InitProducerIdResponse)response;
            Errors error = initProducerIdResponse.error();
            if (error == Errors.NONE) {
                ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(initProducerIdResponse.data.producerId(), initProducerIdResponse.data.producerEpoch());
                TransactionManager.this.setProducerIdAndEpoch(producerIdAndEpoch);
                TransactionManager.this.transitionTo(State.READY);
                TransactionManager.this.lastError = null;
                if (this.isEpochBump) {
                    TransactionManager.this.resetSequenceNumbers();
                }
                this.result.done();
            } else if (error == Errors.NOT_COORDINATOR || error == Errors.COORDINATOR_NOT_AVAILABLE) {
                TransactionManager.this.lookupCoordinator(FindCoordinatorRequest.CoordinatorType.TRANSACTION, TransactionManager.this.transactionalId);
                this.reenqueue();
            } else if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.CONCURRENT_TRANSACTIONS) {
                this.reenqueue();
            } else if (error == Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED || error == Errors.CLUSTER_AUTHORIZATION_FAILED) {
                this.fatalError(error.exception());
            } else {
                this.fatalError(new KafkaException("Unexpected error in InitProducerIdResponse; " + error.message()));
            }
        }
    }

    abstract class TxnRequestHandler
    implements RequestCompletionHandler {
        protected final TransactionalRequestResult result;
        private boolean isRetry = false;

        TxnRequestHandler(TransactionalRequestResult result) {
            this.result = result;
        }

        TxnRequestHandler(String operation) {
            this(new TransactionalRequestResult(operation));
        }

        void fatalError(RuntimeException e) {
            this.result.fail(e);
            TransactionManager.this.transitionToFatalError(e);
        }

        void abortableError(RuntimeException e) {
            this.result.fail(e);
            TransactionManager.this.transitionToAbortableError(e);
        }

        void abortableErrorIfPossible(RuntimeException e) {
            if (TransactionManager.this.canBumpEpoch()) {
                TransactionManager.this.epochBumpRequired = true;
                this.abortableError(e);
            } else {
                this.fatalError(e);
            }
        }

        void fail(RuntimeException e) {
            this.result.fail(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reenqueue() {
            TransactionManager transactionManager = TransactionManager.this;
            synchronized (transactionManager) {
                this.isRetry = true;
                TransactionManager.this.enqueueRequest(this);
            }
        }

        long retryBackoffMs() {
            return TransactionManager.this.retryBackoffMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(ClientResponse response) {
            if (response.requestHeader().correlationId() != TransactionManager.this.inFlightRequestCorrelationId) {
                this.fatalError(new RuntimeException("Detected more than one in-flight transactional request."));
            } else {
                TransactionManager.this.clearInFlightCorrelationId();
                if (response.wasDisconnected()) {
                    TransactionManager.this.log.debug("Disconnected from {}. Will retry.", (Object)response.destination());
                    if (this.needsCoordinator()) {
                        TransactionManager.this.lookupCoordinator(this.coordinatorType(), this.coordinatorKey());
                    }
                    this.reenqueue();
                } else if (response.versionMismatch() != null) {
                    this.fatalError(response.versionMismatch());
                } else if (response.hasResponse()) {
                    TransactionManager.this.log.trace("Received transactional response {} for request {}", (Object)response.responseBody(), (Object)this.requestBuilder());
                    TransactionManager transactionManager = TransactionManager.this;
                    synchronized (transactionManager) {
                        this.handleResponse(response.responseBody());
                    }
                } else {
                    this.fatalError(new KafkaException("Could not execute transactional request for unknown reasons"));
                }
            }
        }

        boolean needsCoordinator() {
            return this.coordinatorType() != null;
        }

        FindCoordinatorRequest.CoordinatorType coordinatorType() {
            return FindCoordinatorRequest.CoordinatorType.TRANSACTION;
        }

        String coordinatorKey() {
            return TransactionManager.this.transactionalId;
        }

        void setRetry() {
            this.isRetry = true;
        }

        boolean isRetry() {
            return this.isRetry;
        }

        boolean isEndTxn() {
            return false;
        }

        abstract AbstractRequest.Builder<?> requestBuilder();

        abstract void handleResponse(AbstractResponse var1);

        abstract Priority priority();
    }

    private static enum Priority {
        FIND_COORDINATOR(0),
        INIT_PRODUCER_ID(1),
        ADD_PARTITIONS_OR_OFFSETS(2),
        END_TXN(3),
        EPOCH_BUMP(4);

        final int priority;

        private Priority(int priority) {
            this.priority = priority;
        }
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZING,
        READY,
        IN_TRANSACTION,
        COMMITTING_TRANSACTION,
        ABORTING_TRANSACTION,
        ABORTABLE_ERROR,
        FATAL_ERROR;


        private boolean isTransitionValid(State source, State target) {
            switch (target) {
                case UNINITIALIZED: {
                    return source == READY;
                }
                case INITIALIZING: {
                    return source == UNINITIALIZED || source == ABORTING_TRANSACTION;
                }
                case READY: {
                    return source == INITIALIZING || source == COMMITTING_TRANSACTION || source == ABORTING_TRANSACTION;
                }
                case IN_TRANSACTION: {
                    return source == READY;
                }
                case COMMITTING_TRANSACTION: {
                    return source == IN_TRANSACTION;
                }
                case ABORTING_TRANSACTION: {
                    return source == IN_TRANSACTION || source == ABORTABLE_ERROR;
                }
                case ABORTABLE_ERROR: {
                    return source == IN_TRANSACTION || source == COMMITTING_TRANSACTION || source == ABORTABLE_ERROR;
                }
            }
            return true;
        }
    }

    private static class TopicPartitionEntry {
        private int nextSequence = 0;
        private int lastAckedSequence = -1;
        private SortedSet<ProducerBatch> inflightBatchesBySequence = new TreeSet<ProducerBatch>(Comparator.comparingInt(ProducerBatch::baseSequence));
        private long lastAckedOffset = -1L;

        TopicPartitionEntry() {
        }

        void resetSequenceNumbers(Consumer<ProducerBatch> resetSequence) {
            TreeSet<ProducerBatch> newInflights = new TreeSet<ProducerBatch>(Comparator.comparingInt(ProducerBatch::baseSequence));
            for (ProducerBatch inflightBatch : this.inflightBatchesBySequence) {
                resetSequence.accept(inflightBatch);
                newInflights.add(inflightBatch);
            }
            this.inflightBatchesBySequence = newInflights;
        }
    }

    private static class TopicPartitionBookkeeper {
        private final Map<TopicPartition, TopicPartitionEntry> topicPartitions = new HashMap<TopicPartition, TopicPartitionEntry>();

        private TopicPartitionBookkeeper() {
        }

        private TopicPartitionEntry getPartition(TopicPartition topicPartition) {
            TopicPartitionEntry ent = this.topicPartitions.get(topicPartition);
            if (ent == null) {
                throw new IllegalStateException("Trying to get the sequence number for " + topicPartition + ", but the sequence number was never set for this partition.");
            }
            return ent;
        }

        private void addPartition(TopicPartition topicPartition) {
            this.topicPartitions.putIfAbsent(topicPartition, new TopicPartitionEntry());
        }

        private boolean contains(TopicPartition topicPartition) {
            return this.topicPartitions.containsKey(topicPartition);
        }

        private void reset() {
            this.topicPartitions.clear();
        }

        private OptionalLong lastAckedOffset(TopicPartition topicPartition) {
            TopicPartitionEntry entry = this.topicPartitions.get(topicPartition);
            if (entry != null && entry.lastAckedOffset != -1L) {
                return OptionalLong.of(entry.lastAckedOffset);
            }
            return OptionalLong.empty();
        }

        private OptionalInt lastAckedSequence(TopicPartition topicPartition) {
            TopicPartitionEntry entry = this.topicPartitions.get(topicPartition);
            if (entry != null && entry.lastAckedSequence != -1) {
                return OptionalInt.of(entry.lastAckedSequence);
            }
            return OptionalInt.empty();
        }

        private void startSequencesAtBeginning(TopicPartition topicPartition, ProducerIdAndEpoch newProducerIdAndEpoch) {
            PrimitiveRef.IntRef sequence = PrimitiveRef.ofInt(0);
            TopicPartitionEntry topicPartitionEntry = this.getPartition(topicPartition);
            topicPartitionEntry.resetSequenceNumbers(inFlightBatch -> {
                inFlightBatch.resetProducerState(newProducerIdAndEpoch, sequence.value, inFlightBatch.isTransactional());
                sequence.value += inFlightBatch.recordCount;
            });
            topicPartitionEntry.nextSequence = sequence.value;
            topicPartitionEntry.lastAckedSequence = -1;
        }
    }
}

