/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message;

import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.JsonNode;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.node.IntNode;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.node.ShortNode;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.node.TextNode;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Message;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ControlledShutdownResponseData
implements ApiMessage {
    private short errorCode;
    private RemainingPartitionCollection remainingPartitions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public ControlledShutdownResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ControlledShutdownResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ControlledShutdownResponseData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public ControlledShutdownResponseData() {
        this.errorCode = 0;
        this.remainingPartitions = new RemainingPartitionCollection(0);
    }

    @Override
    public short apiKey() {
        return 7;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        RemainingPartitionCollection newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field remainingPartitions was serialized as null");
            }
            newCollection = new RemainingPartitionCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new RemainingPartition(_readable, _version));
            }
            this.remainingPartitions = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field remainingPartitions was serialized as null");
            }
            newCollection = new RemainingPartitionCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new RemainingPartition(_readable, _version));
            }
            this.remainingPartitions = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.remainingPartitions.size() + 1);
            for (RemainingPartition remainingPartitionsElement : this.remainingPartitions) {
                remainingPartitionsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.remainingPartitions.size());
            for (RemainingPartition remainingPartitionsElement : this.remainingPartitions) {
                remainingPartitionsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.errorCode = struct.getShort("error_code");
        Object[] _nestedObjects = struct.getArray("remaining_partitions");
        this.remainingPartitions = new RemainingPartitionCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.remainingPartitions.add(new RemainingPartition((Struct)nestedObject, _version));
        }
        if (_version >= 3 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 3) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] _nestedObjects = new Struct[this.remainingPartitions.size()];
        int i = 0;
        for (RemainingPartition element : this.remainingPartitions) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("remaining_partitions", (Object)_nestedObjects);
        if (_version >= 3) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("ControlledShutdownResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        this.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ControlledShutdownResponseData");
        JsonNode _remainingPartitionsNode = _node.get("remainingPartitions");
        if (_remainingPartitionsNode == null) {
            throw new RuntimeException("ControlledShutdownResponseData: unable to locate field 'remainingPartitions', which is mandatory in version " + _version);
        }
        if (!_remainingPartitionsNode.isArray()) {
            throw new RuntimeException("ControlledShutdownResponseData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        this.remainingPartitions = new RemainingPartitionCollection();
        for (JsonNode _element : _remainingPartitionsNode) {
            this.remainingPartitions.add(new RemainingPartition(_element, _version));
        }
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("errorCode", new ShortNode(this.errorCode));
        ArrayNode _remainingPartitionsArray = new ArrayNode(JsonNodeFactory.instance);
        for (RemainingPartition _element : this.remainingPartitions) {
            _remainingPartitionsArray.add(_element.toJson(_version));
        }
        _node.set("remainingPartitions", _remainingPartitionsArray);
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        int _arraySize = 0;
        _arraySize = _version >= 3 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.remainingPartitions.size() + 1)) : (_arraySize += 4);
        for (RemainingPartition remainingPartitionsElement : this.remainingPartitions) {
            _arraySize += remainingPartitionsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 3) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ControlledShutdownResponseData)) {
            return false;
        }
        ControlledShutdownResponseData other = (ControlledShutdownResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.remainingPartitions == null ? other.remainingPartitions != null : !this.remainingPartitions.equals(other.remainingPartitions));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.remainingPartitions == null ? 0 : this.remainingPartitions.hashCode());
        return hashCode;
    }

    @Override
    public ControlledShutdownResponseData duplicate() {
        ControlledShutdownResponseData _duplicate = new ControlledShutdownResponseData();
        _duplicate.errorCode = this.errorCode;
        RemainingPartitionCollection newRemainingPartitions = new RemainingPartitionCollection(this.remainingPartitions.size());
        for (RemainingPartition _element : this.remainingPartitions) {
            newRemainingPartitions.add(_element.duplicate());
        }
        _duplicate.remainingPartitions = newRemainingPartitions;
        return _duplicate;
    }

    public String toString() {
        return "ControlledShutdownResponseData(errorCode=" + this.errorCode + ", remainingPartitions=" + MessageUtil.deepToString(this.remainingPartitions.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public RemainingPartitionCollection remainingPartitions() {
        return this.remainingPartitions;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ControlledShutdownResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ControlledShutdownResponseData setRemainingPartitions(RemainingPartitionCollection v) {
        this.remainingPartitions = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("remaining_partitions", new ArrayOf(RemainingPartition.SCHEMA_0), "The partitions that the broker still leads.")));
        SCHEMA_3 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("remaining_partitions", new CompactArrayOf(RemainingPartition.SCHEMA_3), "The partitions that the broker still leads."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class RemainingPartitionCollection
    extends ImplicitLinkedHashMultiCollection<RemainingPartition> {
        public RemainingPartitionCollection() {
        }

        public RemainingPartitionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public RemainingPartitionCollection(Iterator<RemainingPartition> iterator) {
            super(iterator);
        }

        public RemainingPartition find(String topicName, int partitionIndex) {
            RemainingPartition _key = new RemainingPartition();
            _key.setTopicName(topicName);
            _key.setPartitionIndex(partitionIndex);
            return this.find(_key);
        }

        public List<RemainingPartition> findAll(String topicName, int partitionIndex) {
            RemainingPartition _key = new RemainingPartition();
            _key.setTopicName(topicName);
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public RemainingPartitionCollection duplicate() {
            RemainingPartitionCollection _duplicate = new RemainingPartitionCollection(this.size());
            for (RemainingPartition _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class RemainingPartition
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String topicName;
        private int partitionIndex;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public RemainingPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public RemainingPartition(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public RemainingPartition(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
            this.prev = -2;
            this.next = -2;
        }

        public RemainingPartition() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of RemainingPartition");
            }
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            this.partitionIndex = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.partitionIndex);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of RemainingPartition");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
            if (_version >= 3 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of RemainingPartition");
            }
            TreeMap _taggedFields = null;
            if (_version >= 3) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (_version >= 3) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("RemainingPartition: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("RemainingPartition expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            this.topicName = _topicNameNode.asText();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("RemainingPartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            this.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "RemainingPartition");
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicName", new TextNode(this.topicName));
            _node.set("partitionIndex", new IntNode(this.partitionIndex));
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of RemainingPartition");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size = _version >= 3 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 3) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof RemainingPartition)) {
                return false;
            }
            RemainingPartition other = (RemainingPartition)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemainingPartition)) {
                return false;
            }
            RemainingPartition other = (RemainingPartition)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public RemainingPartition duplicate() {
            RemainingPartition _duplicate = new RemainingPartition();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            return _duplicate;
        }

        public String toString() {
            return "RemainingPartition(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public RemainingPartition setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public RemainingPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The name of the topic."), new Field("partition_index", Type.INT32, "The index of the partition.")));
            SCHEMA_3 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The name of the topic."), new Field("partition_index", Type.INT32, "The index of the partition."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

