/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.metrics.stats;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.metrics.CompoundStat;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.metrics.MetricConfig;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.metrics.stats.Histogram;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.metrics.stats.Percentile;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.metrics.stats.SampledStat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Percentiles
extends SampledStat
implements CompoundStat {
    private final Logger log = LoggerFactory.getLogger(Percentiles.class);
    private final int buckets;
    private final Percentile[] percentiles;
    private final Histogram.BinScheme binScheme;
    private final double min;
    private final double max;

    public Percentiles(int sizeInBytes, double max, BucketSizing bucketing, Percentile ... percentiles) {
        this(sizeInBytes, 0.0, max, bucketing, percentiles);
    }

    public Percentiles(int sizeInBytes, double min, double max, BucketSizing bucketing, Percentile ... percentiles) {
        super(0.0);
        this.percentiles = percentiles;
        this.buckets = sizeInBytes / 4;
        this.min = min;
        this.max = max;
        if (bucketing == BucketSizing.CONSTANT) {
            this.binScheme = new Histogram.ConstantBinScheme(this.buckets, min, max);
        } else if (bucketing == BucketSizing.LINEAR) {
            if (min != 0.0) {
                throw new IllegalArgumentException("Linear bucket sizing requires min to be 0.0.");
            }
            this.binScheme = new Histogram.LinearBinScheme(this.buckets, max);
        } else {
            throw new IllegalArgumentException("Unknown bucket type: " + (Object)((Object)bucketing));
        }
    }

    @Override
    public List<CompoundStat.NamedMeasurable> stats() {
        ArrayList<CompoundStat.NamedMeasurable> ms = new ArrayList<CompoundStat.NamedMeasurable>(this.percentiles.length);
        for (Percentile percentile : this.percentiles) {
            double pct = percentile.percentile();
            ms.add(new CompoundStat.NamedMeasurable(percentile.name(), (config, now) -> this.value(config, now, pct / 100.0)));
        }
        return ms;
    }

    public double value(MetricConfig config, long now, double quantile) {
        this.purgeObsoleteSamples(config, now);
        float count = 0.0f;
        for (SampledStat.Sample sample : this.samples) {
            count += (float)sample.eventCount;
        }
        if (count == 0.0f) {
            return Double.NaN;
        }
        float sum = 0.0f;
        float quant = (float)quantile;
        for (int b = 0; b < this.buckets; ++b) {
            for (SampledStat.Sample s : this.samples) {
                HistogramSample sample = (HistogramSample)s;
                float[] hist = sample.histogram.counts();
                if (!((sum += hist[b]) / count > quant)) continue;
                return this.binScheme.fromBin(b);
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
        return this.value(config, now, 0.5);
    }

    @Override
    protected HistogramSample newSample(long timeMs) {
        return new HistogramSample(this.binScheme, timeMs);
    }

    @Override
    protected void update(SampledStat.Sample sample, MetricConfig config, double value, long timeMs) {
        double boundedValue;
        if (value > this.max) {
            this.log.warn("Received value {} which is greater than max recordable value {}, will be pinned to the max value", (Object)value, (Object)this.max);
            boundedValue = this.max;
        } else if (value < this.min) {
            this.log.warn("Received value {} which is less than min recordable value {}, will be pinned to the min value", (Object)value, (Object)this.min);
            boundedValue = this.min;
        } else {
            boundedValue = value;
        }
        HistogramSample hist = (HistogramSample)sample;
        hist.histogram.record(boundedValue);
    }

    private static class HistogramSample
    extends SampledStat.Sample {
        private final Histogram histogram;

        private HistogramSample(Histogram.BinScheme scheme, long now) {
            super(0.0, now);
            this.histogram = new Histogram(scheme);
        }

        @Override
        public void reset(long now) {
            super.reset(now);
            this.histogram.clear();
        }
    }

    public static enum BucketSizing {
        CONSTANT,
        LINEAR;

    }
}

