/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.KafkaException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.config.SslConfigs;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.memory.MemoryPool;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.Authenticator;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.ChannelBuilder;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.ChannelBuilders;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.ChannelMetadataRegistry;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.KafkaChannel;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.ListenerName;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.ListenerReconfigurable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.Mode;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.SslTransportLayer;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.auth.SslAuthenticationContext;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.ssl.SslFactory;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class SslChannelBuilder
implements ChannelBuilder,
ListenerReconfigurable {
    private final ListenerName listenerName;
    private final boolean isInterBrokerListener;
    private SslFactory sslFactory;
    private Mode mode;
    private Map<String, ?> configs;
    private SslPrincipalMapper sslPrincipalMapper;
    private final Logger log;

    public SslChannelBuilder(Mode mode, ListenerName listenerName, boolean isInterBrokerListener, LogContext logContext) {
        this.mode = mode;
        this.listenerName = listenerName;
        this.isInterBrokerListener = isInterBrokerListener;
        this.log = logContext.logger(this.getClass());
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            String sslPrincipalMappingRules = (String)configs.get("ssl.principal.mapping.rules");
            if (sslPrincipalMappingRules != null) {
                this.sslPrincipalMapper = SslPrincipalMapper.fromRules(sslPrincipalMappingRules);
            }
            this.sslFactory = new SslFactory(this.mode, null, this.isInterBrokerListener);
            this.sslFactory.configure(this.configs);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SslConfigs.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        this.sslFactory.validateReconfiguration(configs);
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        this.sslFactory.reconfigure(configs);
    }

    @Override
    public ListenerName listenerName() {
        return this.listenerName;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry) throws KafkaException {
        try {
            SslTransportLayer transportLayer = this.buildTransportLayer(this.sslFactory, id, key, this.peerHost(key), metadataRegistry);
            Supplier<Authenticator> authenticatorCreator = () -> new SslAuthenticator(this.configs, transportLayer, this.listenerName, this.sslPrincipalMapper);
            return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE, metadataRegistry);
        }
        catch (Exception e) {
            this.log.info("Failed to create channel due to ", e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        if (this.sslFactory != null) {
            this.sslFactory.close();
        }
    }

    protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, String host, ChannelMetadataRegistry metadataRegistry) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return SslTransportLayer.create(id, key, sslFactory.createSslEngine(host, socketChannel.socket().getPort()), metadataRegistry);
    }

    private String peerHost(SelectionKey key) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return new InetSocketAddress(socketChannel.socket().getInetAddress(), 0).getHostString();
    }

    private static class SslAuthenticator
    implements Authenticator {
        private final SslTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;
        private final ListenerName listenerName;

        private SslAuthenticator(Map<String, ?> configs, SslTransportLayer transportLayer, ListenerName listenerName, SslPrincipalMapper sslPrincipalMapper) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, transportLayer, this, null, sslPrincipalMapper);
            this.listenerName = listenerName;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            if (this.listenerName == null) {
                throw new IllegalStateException("Unexpected call to principal() when listenerName is null");
            }
            SslAuthenticationContext context = new SslAuthenticationContext(this.transportLayer.sslSession(), clientAddress, this.listenerName.value());
            return this.principalBuilder.build(context);
        }

        @Override
        public void close() throws IOException {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }

        @Override
        public boolean complete() {
            return true;
        }
    }
}

