/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.InvalidRecordException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.ControlRecordType;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.DefaultRecord;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.Record;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionMarker {
    private static final Logger log = LoggerFactory.getLogger(EndTransactionMarker.class);
    private static final short CURRENT_END_TXN_MARKER_VERSION = 0;
    private static final Schema END_TXN_MARKER_SCHEMA_VERSION_V0 = new Schema(new Field("version", Type.INT16), new Field("coordinator_epoch", Type.INT32));
    static final int CURRENT_END_TXN_MARKER_VALUE_SIZE = 6;
    static final int CURRENT_END_TXN_SCHEMA_RECORD_SIZE = DefaultRecord.sizeInBytes(0, 0L, 4, 6, Record.EMPTY_HEADERS);
    private final ControlRecordType type;
    private final int coordinatorEpoch;

    public EndTransactionMarker(ControlRecordType type, int coordinatorEpoch) {
        EndTransactionMarker.ensureTransactionMarkerControlType(type);
        this.type = type;
        this.coordinatorEpoch = coordinatorEpoch;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ControlRecordType controlType() {
        return this.type;
    }

    private Struct buildRecordValue() {
        Struct struct = new Struct(END_TXN_MARKER_SCHEMA_VERSION_V0);
        struct.set("version", (Object)0);
        struct.set("coordinator_epoch", (Object)this.coordinatorEpoch);
        return struct;
    }

    public ByteBuffer serializeValue() {
        Struct valueStruct = this.buildRecordValue();
        ByteBuffer value = ByteBuffer.allocate(valueStruct.sizeOf());
        valueStruct.writeTo(value);
        value.flip();
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndTransactionMarker that = (EndTransactionMarker)o;
        return this.coordinatorEpoch == that.coordinatorEpoch && this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.coordinatorEpoch;
        return result;
    }

    private static void ensureTransactionMarkerControlType(ControlRecordType type) {
        if (type != ControlRecordType.COMMIT && type != ControlRecordType.ABORT) {
            throw new IllegalArgumentException("Invalid control record type for end transaction marker" + (Object)((Object)type));
        }
    }

    public static EndTransactionMarker deserialize(Record record) {
        ControlRecordType type = ControlRecordType.parse(record.key());
        return EndTransactionMarker.deserializeValue(type, record.value());
    }

    static EndTransactionMarker deserializeValue(ControlRecordType type, ByteBuffer value) {
        EndTransactionMarker.ensureTransactionMarkerControlType(type);
        if (value.remaining() < 6) {
            throw new InvalidRecordException("Invalid value size found for end transaction marker. Must have at least 6 bytes, but found only " + value.remaining());
        }
        short version = value.getShort(0);
        if (version < 0) {
            throw new InvalidRecordException("Invalid version found for end transaction marker: " + version + ". May indicate data corruption");
        }
        if (version > 0) {
            log.debug("Received end transaction marker value version {}. Parsing as version {}", (Object)version, (Object)0);
        }
        int coordinatorEpoch = value.getInt(2);
        return new EndTransactionMarker(type, coordinatorEpoch);
    }
}

