/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.io.IOException;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public final class KafkaLZ4BlockOutputStream
extends OutputStream {
    public static final int MAGIC = 407708164;
    public static final int LZ4_MAX_HEADER_LENGTH = 19;
    public static final int LZ4_FRAME_INCOMPRESSIBLE_MASK = Integer.MIN_VALUE;
    public static final String CLOSED_STREAM = "The stream is already closed";
    public static final int BLOCKSIZE_64KB = 4;
    public static final int BLOCKSIZE_256KB = 5;
    public static final int BLOCKSIZE_1MB = 6;
    public static final int BLOCKSIZE_4MB = 7;
    private final LZ4Compressor compressor;
    private final XXHash32 checksum;
    private final boolean useBrokenFlagDescriptorChecksum;
    private final FLG flg;
    private final BD bd;
    private final int maxBlockSize;
    private OutputStream out;
    private byte[] buffer;
    private byte[] compressedBuffer;
    private int bufferOffset;
    private boolean finished;

    public KafkaLZ4BlockOutputStream(OutputStream out, int blockSize, boolean blockChecksum, boolean useBrokenFlagDescriptorChecksum) throws IOException {
        this.out = out;
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.checksum = XXHashFactory.fastestInstance().hash32();
        this.useBrokenFlagDescriptorChecksum = useBrokenFlagDescriptorChecksum;
        this.bd = new BD(blockSize);
        this.flg = new FLG(blockChecksum);
        this.bufferOffset = 0;
        this.maxBlockSize = this.bd.getBlockMaximumSize();
        this.buffer = new byte[this.maxBlockSize];
        this.compressedBuffer = new byte[this.compressor.maxCompressedLength(this.maxBlockSize)];
        this.finished = false;
        this.writeHeader();
    }

    public KafkaLZ4BlockOutputStream(OutputStream out, int blockSize, boolean blockChecksum) throws IOException {
        this(out, blockSize, blockChecksum, false);
    }

    public KafkaLZ4BlockOutputStream(OutputStream out, int blockSize) throws IOException {
        this(out, blockSize, false, false);
    }

    public KafkaLZ4BlockOutputStream(OutputStream out) throws IOException {
        this(out, 4);
    }

    public KafkaLZ4BlockOutputStream(OutputStream out, boolean useBrokenHC) throws IOException {
        this(out, 4, false, useBrokenHC);
    }

    public boolean useBrokenFlagDescriptorChecksum() {
        return this.useBrokenFlagDescriptorChecksum;
    }

    private void writeHeader() throws IOException {
        ByteUtils.writeUnsignedIntLE(this.buffer, 0, 407708164);
        this.bufferOffset = 4;
        this.buffer[this.bufferOffset++] = this.flg.toByte();
        this.buffer[this.bufferOffset++] = this.bd.toByte();
        int offset = 4;
        int len = this.bufferOffset - offset;
        if (this.useBrokenFlagDescriptorChecksum) {
            len += offset;
            offset = 0;
        }
        byte hash = (byte)(this.checksum.hash(this.buffer, offset, len, 0) >> 8 & 0xFF);
        this.buffer[this.bufferOffset++] = hash;
        this.out.write(this.buffer, 0, this.bufferOffset);
        this.bufferOffset = 0;
    }

    private void writeBlock() throws IOException {
        if (this.bufferOffset == 0) {
            return;
        }
        int compressedLength = this.compressor.compress(this.buffer, 0, this.bufferOffset, this.compressedBuffer, 0);
        byte[] bufferToWrite = this.compressedBuffer;
        int compressMethod = 0;
        if (compressedLength >= this.bufferOffset) {
            bufferToWrite = this.buffer;
            compressedLength = this.bufferOffset;
            compressMethod = Integer.MIN_VALUE;
        }
        ByteUtils.writeUnsignedIntLE(this.out, compressedLength | compressMethod);
        this.out.write(bufferToWrite, 0, compressedLength);
        if (this.flg.isBlockChecksumSet()) {
            int hash = this.checksum.hash(bufferToWrite, 0, compressedLength, 0);
            ByteUtils.writeUnsignedIntLE(this.out, hash);
        }
        this.bufferOffset = 0;
    }

    private void writeEndMark() throws IOException {
        ByteUtils.writeUnsignedIntLE(this.out, 0);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureNotFinished();
        if (this.bufferOffset == this.maxBlockSize) {
            this.writeBlock();
        }
        this.buffer[this.bufferOffset++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        SafeUtils.checkRange(b, off, len);
        this.ensureNotFinished();
        int bufferRemainingLength = this.maxBlockSize - this.bufferOffset;
        while (len > bufferRemainingLength) {
            System.arraycopy(b, off, this.buffer, this.bufferOffset, bufferRemainingLength);
            this.bufferOffset = this.maxBlockSize;
            this.writeBlock();
            off += bufferRemainingLength;
            len -= bufferRemainingLength;
            bufferRemainingLength = this.maxBlockSize;
        }
        System.arraycopy(b, off, this.buffer, this.bufferOffset, len);
        this.bufferOffset += len;
    }

    @Override
    public void flush() throws IOException {
        if (!this.finished) {
            this.writeBlock();
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    private void ensureNotFinished() {
        if (this.finished) {
            throw new IllegalStateException(CLOSED_STREAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.finished) return;
            this.writeBlock();
            this.writeEndMark();
            return;
        }
        finally {
            block28: {
                try {
                    if (this.out == null) break block28;
                    try (OutputStream outStream = this.out;){
                        outStream.flush();
                    }
                }
                finally {
                    this.out = null;
                    this.buffer = null;
                    this.compressedBuffer = null;
                    this.finished = true;
                }
            }
        }
    }

    public static class BD {
        private final int reserved2;
        private final int blockSizeValue;
        private final int reserved3;

        public BD() {
            this(0, 4, 0);
        }

        public BD(int blockSizeValue) {
            this(0, blockSizeValue, 0);
        }

        private BD(int reserved2, int blockSizeValue, int reserved3) {
            this.reserved2 = reserved2;
            this.blockSizeValue = blockSizeValue;
            this.reserved3 = reserved3;
            this.validate();
        }

        public static BD fromByte(byte bd) {
            int reserved2 = bd >>> 0 & 0xF;
            int blockMaximumSize = bd >>> 4 & 7;
            int reserved3 = bd >>> 7 & 1;
            return new BD(reserved2, blockMaximumSize, reserved3);
        }

        private void validate() {
            if (this.reserved2 != 0) {
                throw new RuntimeException("Reserved2 field must be 0");
            }
            if (this.blockSizeValue < 4 || this.blockSizeValue > 7) {
                throw new RuntimeException("Block size value must be between 4 and 7");
            }
            if (this.reserved3 != 0) {
                throw new RuntimeException("Reserved3 field must be 0");
            }
        }

        public int getBlockMaximumSize() {
            return 1 << 2 * this.blockSizeValue + 8;
        }

        public byte toByte() {
            return (byte)((this.reserved2 & 0xF) << 0 | (this.blockSizeValue & 7) << 4 | (this.reserved3 & 1) << 7);
        }
    }

    public static class FLG {
        private static final int VERSION = 1;
        private final int reserved;
        private final int contentChecksum;
        private final int contentSize;
        private final int blockChecksum;
        private final int blockIndependence;
        private final int version;

        public FLG() {
            this(false);
        }

        public FLG(boolean blockChecksum) {
            this(0, 0, 0, blockChecksum ? 1 : 0, 1, 1);
        }

        private FLG(int reserved, int contentChecksum, int contentSize, int blockChecksum, int blockIndependence, int version) {
            this.reserved = reserved;
            this.contentChecksum = contentChecksum;
            this.contentSize = contentSize;
            this.blockChecksum = blockChecksum;
            this.blockIndependence = blockIndependence;
            this.version = version;
            this.validate();
        }

        public static FLG fromByte(byte flg) {
            int reserved = flg >>> 0 & 3;
            int contentChecksum = flg >>> 2 & 1;
            int contentSize = flg >>> 3 & 1;
            int blockChecksum = flg >>> 4 & 1;
            int blockIndependence = flg >>> 5 & 1;
            int version = flg >>> 6 & 3;
            return new FLG(reserved, contentChecksum, contentSize, blockChecksum, blockIndependence, version);
        }

        public byte toByte() {
            return (byte)((this.reserved & 3) << 0 | (this.contentChecksum & 1) << 2 | (this.contentSize & 1) << 3 | (this.blockChecksum & 1) << 4 | (this.blockIndependence & 1) << 5 | (this.version & 3) << 6);
        }

        private void validate() {
            if (this.reserved != 0) {
                throw new RuntimeException("Reserved bits must be 0");
            }
            if (this.blockIndependence != 1) {
                throw new RuntimeException("Dependent block stream is unsupported");
            }
            if (this.version != 1) {
                throw new RuntimeException(String.format("Version %d is unsupported", this.version));
            }
        }

        public boolean isContentChecksumSet() {
            return this.contentChecksum == 1;
        }

        public boolean isContentSizeSet() {
            return this.contentSize == 1;
        }

        public boolean isBlockChecksumSet() {
            return this.blockChecksum == 1;
        }

        public boolean isBlockIndependenceSet() {
            return this.blockIndependence == 1;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

