/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica.ReplicaView;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface PartitionView {
    public Set<ReplicaView> replicas();

    public ReplicaView leader();

    public static class DefaultPartitionView
    implements PartitionView {
        private final Set<ReplicaView> replicas;
        private final ReplicaView leader;

        public DefaultPartitionView(Set<ReplicaView> replicas, ReplicaView leader) {
            this.replicas = Collections.unmodifiableSet(replicas);
            this.leader = leader;
        }

        @Override
        public Set<ReplicaView> replicas() {
            return this.replicas;
        }

        @Override
        public ReplicaView leader() {
            return this.leader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultPartitionView that = (DefaultPartitionView)o;
            return Objects.equals(this.replicas, that.replicas) && Objects.equals(this.leader, that.leader);
        }

        public int hashCode() {
            return Objects.hash(this.replicas, this.leader);
        }

        public String toString() {
            return "DefaultPartitionView{replicas=" + this.replicas + ", leader=" + this.leader + '}';
        }
    }
}

