/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica.ClientMetadata;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica.PartitionView;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica.ReplicaSelector;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica.ReplicaView;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RackAwareReplicaSelector
implements ReplicaSelector {
    @Override
    public Optional<ReplicaView> select(TopicPartition topicPartition, ClientMetadata clientMetadata, PartitionView partitionView) {
        if (clientMetadata.rackId() != null && !clientMetadata.rackId().isEmpty()) {
            Set sameRackReplicas = partitionView.replicas().stream().filter(replicaInfo -> clientMetadata.rackId().equals(replicaInfo.endpoint().rack())).collect(Collectors.toSet());
            if (sameRackReplicas.isEmpty()) {
                return Optional.of(partitionView.leader());
            }
            if (sameRackReplicas.contains(partitionView.leader())) {
                return Optional.of(partitionView.leader());
            }
            return sameRackReplicas.stream().max(ReplicaView.comparator());
        }
        return Optional.of(partitionView.leader());
    }
}

