/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.NetworkSend;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.Send;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterClientQuotasResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterConfigsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ApiError;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ApiVersionsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ControlledShutdownResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreateAclsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreatePartitionsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreateTopicsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteAclsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteGroupsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteRecordsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteTopicsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeAclsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeConfigsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeGroupsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeLogDirsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ElectLeadersResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.EndTxnResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FetchResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.HeartbeatResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.InitProducerIdResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.JoinGroupResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.LeaderAndIsrResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.LeaveGroupResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ListGroupsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ListOffsetResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.MetadataResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetCommitResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetDeleteResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetFetchResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ProduceResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RequestUtils;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ResponseHeader;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SaslAuthenticateResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SaslHandshakeResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.StopReplicaResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SyncGroupResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.UpdateMetadataResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractResponse
implements AbstractRequestResponse {
    public static final int DEFAULT_THROTTLE_TIME = 0;

    protected Send toSend(String destination, ResponseHeader header, short apiVersion) {
        return new NetworkSend(destination, RequestUtils.serialize(header.toStruct(), this.toStruct(apiVersion)));
    }

    public ByteBuffer serialize(short version, ResponseHeader responseHeader) {
        return RequestUtils.serialize(responseHeader.toStruct(), this.toStruct(version));
    }

    public ByteBuffer serialize(ApiKeys apiKey, short version, int correlationId) {
        ResponseHeader header = new ResponseHeader(correlationId, apiKey.responseHeaderVersion(version));
        return RequestUtils.serialize(header.toStruct(), this.toStruct(version));
    }

    public abstract Map<Errors, Integer> errorCounts();

    protected Map<Errors, Integer> errorCounts(Errors error) {
        return Collections.singletonMap(error, 1);
    }

    protected Map<Errors, Integer> errorCounts(Stream<Errors> errors) {
        return errors.collect(Collectors.groupingBy(e -> e, Collectors.summingInt(e -> 1)));
    }

    protected Map<Errors, Integer> errorCounts(Collection<Errors> errors) {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (Errors error : errors) {
            this.updateErrorCounts(errorCounts, error);
        }
        return errorCounts;
    }

    protected Map<Errors, Integer> apiErrorCounts(Map<?, ApiError> errors) {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (ApiError apiError : errors.values()) {
            this.updateErrorCounts(errorCounts, apiError.error());
        }
        return errorCounts;
    }

    protected void updateErrorCounts(Map<Errors, Integer> errorCounts, Errors error) {
        Integer count = errorCounts.getOrDefault((Object)error, 0);
        errorCounts.put(error, count + 1);
    }

    protected abstract Struct toStruct(short var1);

    public static AbstractResponse parseResponse(ApiKeys apiKey, Struct struct, short version) {
        switch (apiKey) {
            case PRODUCE: {
                return new ProduceResponse(struct);
            }
            case FETCH: {
                return FetchResponse.parse(struct);
            }
            case LIST_OFFSETS: {
                return new ListOffsetResponse(struct);
            }
            case METADATA: {
                return new MetadataResponse(struct, version);
            }
            case OFFSET_COMMIT: {
                return new OffsetCommitResponse(struct, version);
            }
            case OFFSET_FETCH: {
                return new OffsetFetchResponse(struct, version);
            }
            case FIND_COORDINATOR: {
                return new FindCoordinatorResponse(struct, version);
            }
            case JOIN_GROUP: {
                return new JoinGroupResponse(struct, version);
            }
            case HEARTBEAT: {
                return new HeartbeatResponse(struct, version);
            }
            case LEAVE_GROUP: {
                return new LeaveGroupResponse(struct, version);
            }
            case SYNC_GROUP: {
                return new SyncGroupResponse(struct, version);
            }
            case STOP_REPLICA: {
                return new StopReplicaResponse(struct, version);
            }
            case CONTROLLED_SHUTDOWN: {
                return new ControlledShutdownResponse(struct, version);
            }
            case UPDATE_METADATA: {
                return new UpdateMetadataResponse(struct, version);
            }
            case LEADER_AND_ISR: {
                return new LeaderAndIsrResponse(struct, version);
            }
            case DESCRIBE_GROUPS: {
                return new DescribeGroupsResponse(struct, version);
            }
            case LIST_GROUPS: {
                return new ListGroupsResponse(struct, version);
            }
            case SASL_HANDSHAKE: {
                return new SaslHandshakeResponse(struct, version);
            }
            case API_VERSIONS: {
                return ApiVersionsResponse.fromStruct(struct, version);
            }
            case CREATE_TOPICS: {
                return new CreateTopicsResponse(struct, version);
            }
            case DELETE_TOPICS: {
                return new DeleteTopicsResponse(struct, version);
            }
            case DELETE_RECORDS: {
                return new DeleteRecordsResponse(struct, version);
            }
            case INIT_PRODUCER_ID: {
                return new InitProducerIdResponse(struct, version);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return new OffsetsForLeaderEpochResponse(struct);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return new AddPartitionsToTxnResponse(struct, version);
            }
            case ADD_OFFSETS_TO_TXN: {
                return new AddOffsetsToTxnResponse(struct, version);
            }
            case END_TXN: {
                return new EndTxnResponse(struct, version);
            }
            case WRITE_TXN_MARKERS: {
                return new WriteTxnMarkersResponse(struct, version);
            }
            case TXN_OFFSET_COMMIT: {
                return new TxnOffsetCommitResponse(struct, version);
            }
            case DESCRIBE_ACLS: {
                return new DescribeAclsResponse(struct, version);
            }
            case CREATE_ACLS: {
                return new CreateAclsResponse(struct, version);
            }
            case DELETE_ACLS: {
                return new DeleteAclsResponse(struct, version);
            }
            case DESCRIBE_CONFIGS: {
                return new DescribeConfigsResponse(struct);
            }
            case ALTER_CONFIGS: {
                return new AlterConfigsResponse(struct, version);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return new AlterReplicaLogDirsResponse(struct);
            }
            case DESCRIBE_LOG_DIRS: {
                return new DescribeLogDirsResponse(struct, version);
            }
            case SASL_AUTHENTICATE: {
                return new SaslAuthenticateResponse(struct, version);
            }
            case CREATE_PARTITIONS: {
                return new CreatePartitionsResponse(struct, version);
            }
            case CREATE_DELEGATION_TOKEN: {
                return new CreateDelegationTokenResponse(struct, version);
            }
            case RENEW_DELEGATION_TOKEN: {
                return new RenewDelegationTokenResponse(struct, version);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return new ExpireDelegationTokenResponse(struct, version);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return new DescribeDelegationTokenResponse(struct, version);
            }
            case DELETE_GROUPS: {
                return new DeleteGroupsResponse(struct, version);
            }
            case ELECT_LEADERS: {
                return new ElectLeadersResponse(struct, version);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return new IncrementalAlterConfigsResponse(struct, version);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return new AlterPartitionReassignmentsResponse(struct, version);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return new ListPartitionReassignmentsResponse(struct, version);
            }
            case OFFSET_DELETE: {
                return new OffsetDeleteResponse(struct, version);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return new DescribeClientQuotasResponse(struct, version);
            }
            case ALTER_CLIENT_QUOTAS: {
                return new AlterClientQuotasResponse(struct, version);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public boolean shouldClientThrottle(short version) {
        return false;
    }

    public int throttleTimeMs() {
        return 0;
    }

    public String toString(short version) {
        return this.toStruct(version).toString();
    }
}

